/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.store.sys.EStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.local.MapEStore;

public class LocalEStoreProvider {
    private ConcurrentMap<PStoreConfig<?>, EStore<?>> estores = Maps.newConcurrentMap();

    public <V> EStore<V> getStore(PStoreConfig<V> storeConfig) throws IOException {
        Preconditions.checkArgument(storeConfig.getMode() == PStoreConfig.Mode.EPHEMERAL, "Estore configurations must be set ephemeral.");
        if (!this.estores.containsKey(storeConfig)) {
            MapEStore p = new MapEStore();
            EStore p2 = this.estores.putIfAbsent(storeConfig, p);
            if (p2 != null) {
                return p2;
            }
            return p;
        }
        return (EStore)this.estores.get(storeConfig);
    }
}

