/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.drill.exec.store.dfs.shim.FileSystemCreator;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePStore<V>
implements PStore<V> {
    static final Logger logger = LoggerFactory.getLogger(FilePStore.class);
    private final Path basePath;
    private final PStoreConfig<V> config;
    private final DrillFileSystem fs;

    public FilePStore(DrillFileSystem fs, Path base, PStoreConfig<V> config) {
        this.basePath = new Path(base, config.getName());
        this.config = config;
        this.fs = fs;
        try {
            this.mk(this.basePath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure setting pstore configuration path.");
        }
    }

    private void mk(Path path) throws IOException {
        this.fs.getUnderlying().mkdirs(path);
    }

    public static Path getLogDir() {
        String drillLogDir = System.getenv("DRILL_LOG_DIR");
        if (drillLogDir == null) {
            drillLogDir = "/var/log/drill";
        }
        return new Path(new File(drillLogDir).getAbsoluteFile().toURI());
    }

    public static DrillFileSystem getFileSystem(DrillConfig config, Path root) throws IOException {
        Path blobRoot = root == null ? FilePStore.getLogDir() : root;
        Configuration fsConf = new Configuration();
        if (blobRoot.toUri().getScheme() != null) {
            fsConf.set("fs.defaultFS", blobRoot.toUri().toString());
        }
        DrillFileSystem fs = FileSystemCreator.getFileSystem(config, fsConf);
        fs.getUnderlying().mkdirs(blobRoot);
        return fs;
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        try {
            List<FileStatus> f = this.fs.list(false, this.basePath);
            if (f == null || f.isEmpty()) {
                return Collections.emptyIterator();
            }
            List<String> files = Lists.newArrayList();
            for (FileStatus stat : f) {
                String s = stat.getPath().getName();
                if (!s.endsWith(".sys.drill")) continue;
                files.add(s.substring(0, s.length() - ".sys.drill".length()));
            }
            Collections.sort(files);
            files = files.subList(0, Math.min(files.size(), this.config.getMaxIteratorSize()));
            return new Iter(files.iterator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path p(String name) throws IOException {
        Preconditions.checkArgument(!name.contains("/") && !name.contains(":") && !name.contains(".."));
        Path f = new Path(this.basePath, name + ".sys.drill");
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(String key) {
        try {
            Path path = this.p(key);
            if (!this.fs.getUnderlying().exists(path)) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FSDataInputStream is = this.fs.open(this.p(key)).getInputStream();){
            Object object = this.config.getSerializer().deserialize(IOUtils.toByteArray((InputStream)is));
            return (V)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void put(String key, V value) {
        try (OutputStream os = this.fs.create(this.p(key)).getOuputStream();){
            IOUtils.write((byte[])this.config.getSerializer().serialize(value), (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        try {
            Path p = this.p(key);
            if (this.fs.getUnderlying().exists(p)) {
                return false;
            }
            this.put(key, value);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.fs.getUnderlying().delete(this.p(key), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class Iter
    implements Iterator<Map.Entry<String, V>> {
        private Iterator<String> keys;
        private String current;

        public Iter(Iterator<String> keys) {
            this.keys = keys;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            this.current = this.keys.next();
            return new DeferredEntry(this.current);
        }

        @Override
        public void remove() {
            FilePStore.this.delete(this.current);
            this.keys.remove();
        }

        private class DeferredEntry
        implements Map.Entry<String, V> {
            private String name;

            public DeferredEntry(String name) {
                this.name = name;
            }

            @Override
            public String getKey() {
                return this.name;
            }

            @Override
            public Object getValue() {
                return FilePStore.this.get(this.name);
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

