/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionIterator
implements Iterator<Object> {
    static final Logger logger = LoggerFactory.getLogger(VersionIterator.class);
    public boolean beforeFirst = true;

    @Override
    public boolean hasNext() {
        return this.beforeFirst;
    }

    @Override
    public Object next() {
        if (!this.beforeFirst) {
            throw new IllegalStateException();
        }
        this.beforeFirst = false;
        return new VersionInfo();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class VersionInfo {
        public String commit_id = "Unknown";
        public String commit_message = "";
        public String commit_time = "";
        public String build_email = "Unknown";
        public String build_time = "";

        public VersionInfo() {
            try {
                URL u = Resources.getResource("git.properties");
                if (u != null) {
                    Properties p = new Properties();
                    p.load((InputStream)Resources.newInputStreamSupplier(u).getInput());
                    this.commit_id = p.getProperty("git.commit.id");
                    this.build_email = p.getProperty("git.build.user.email");
                    this.commit_time = p.getProperty("git.commit.time");
                    this.build_time = p.getProperty("git.build.time");
                    this.commit_message = p.getProperty("git.commit.message.short");
                }
            }
            catch (IOException | IllegalArgumentException e) {
                logger.warn("Failure while trying to load \"git.properties\" file.", e);
            }
        }
    }
}

