/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.sys.SystemTable;
import org.apache.drill.exec.store.sys.SystemTablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="sys")
public class SystemTableScan
extends AbstractGroupScan
implements SubScan {
    static final Logger logger = LoggerFactory.getLogger(SystemTableScan.class);
    private final SystemTable table;
    private final SystemTablePlugin plugin;

    public SystemTableScan(SystemTable table, SystemTablePlugin plugin) {
        this.table = table;
        this.plugin = plugin;
    }

    @Override
    public ScanStats getScanStats() {
        return ScanStats.TRIVIAL_TABLE;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new SystemTableScan(this.table, this.plugin);
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) throws PhysicalOperatorSetupException {
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        return this;
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public long getInitialAllocation() {
        return this.initialAllocation;
    }

    @Override
    public long getMaxAllocation() {
        return this.maxAllocation;
    }

    @Override
    public String getDigest() {
        return "SystemTableScan: " + this.table.name();
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        return Collections.emptyList();
    }

    @Override
    public int getOperatorType() {
        return 23;
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return this;
    }
}

