/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.sys.StaticDrillTable;
import org.apache.drill.exec.store.sys.SystemTable;
import org.apache.drill.exec.store.sys.SystemTablePluginConfig;
import org.apache.drill.exec.store.sys.SystemTableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTablePlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(SystemTablePlugin.class);
    private final DrillbitContext context;
    private final String name;
    private SystemSchema schema = new SystemSchema();

    public SystemTablePlugin(SystemTablePluginConfig configuration, DrillbitContext context, String name) {
        this.context = context;
        this.name = name;
    }

    @Override
    public StoragePluginConfig getConfig() {
        return SystemTablePluginConfig.INSTANCE;
    }

    @Override
    public void registerSchemas(UserSession session, SchemaPlus parent) {
        parent.add(this.schema.getName(), this.schema);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(JSONOptions selection, List<SchemaPath> columns) throws IOException {
        SystemTable table = selection.getWith(this.context.getConfig(), SystemTable.class);
        return new SystemTableScan(table, this);
    }

    private class SystemSchema
    extends AbstractSchema {
        private Set<String> tableNames;

        public SystemSchema() {
            super(ImmutableList.of(), "sys");
            HashSet<String> names = Sets.newHashSet();
            for (SystemTable t : SystemTable.values()) {
                names.add(t.getTableName());
            }
            this.tableNames = ImmutableSet.copyOf(names);
        }

        @Override
        public Set<String> getTableNames() {
            return this.tableNames;
        }

        @Override
        public DrillTable getTable(String name) {
            for (SystemTable table : SystemTable.values()) {
                if (!table.getTableName().equalsIgnoreCase(name)) continue;
                return new StaticDrillTable(table.getType(), SystemTablePlugin.this.name, SystemTablePlugin.this, (Object)table);
            }
            return null;
        }

        @Override
        public String getTypeName() {
            return SystemTablePluginConfig.NAME;
        }
    }
}

