/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.typesafe.config.ConfigException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PStoreRegistry {
    static final Logger logger = LoggerFactory.getLogger(PStoreRegistry.class);
    private DrillConfig config;
    private ClusterCoordinator coord;

    public PStoreRegistry(ClusterCoordinator coord, DrillConfig config) {
        this.coord = coord;
        this.config = config;
    }

    public PStoreProvider newPStoreProvider() throws ExecutionSetupException {
        try {
            String storeProviderClassName = this.config.getString("drill.exec.sys.store.provider.class");
            logger.info("Using the configured PStoreProvider class: '{}'.", (Object)storeProviderClassName);
            Class<?> storeProviderClass = Class.forName(storeProviderClassName);
            Constructor<?> c = storeProviderClass.getConstructor(PStoreRegistry.class);
            return (PStoreProvider)c.newInstance(this);
        }
        catch (ConfigException.Missing | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), e);
            throw new ExecutionSetupException("A System Table provider was either not specified or could not be found or instantiated", e);
        }
    }
}

