/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.dyuproject.protostuff.Schema;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.apache.drill.exec.store.sys.serialize.JacksonSerializer;
import org.apache.drill.exec.store.sys.serialize.PClassSerializer;
import org.apache.drill.exec.store.sys.serialize.ProtoSerializer;

public class PStoreConfig<V> {
    private final String name;
    private final PClassSerializer<V> valueSerializer;
    private final Mode mode;
    private final int maxIteratorSize;

    private PStoreConfig(String name, PClassSerializer<V> valueSerializer, Mode mode, int maxIteratorSize) {
        this.name = name;
        this.valueSerializer = valueSerializer;
        this.mode = mode;
        this.maxIteratorSize = Math.abs(maxIteratorSize);
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getMaxIteratorSize() {
        return this.maxIteratorSize;
    }

    public String getName() {
        return this.name;
    }

    public PClassSerializer<V> getSerializer() {
        return this.valueSerializer;
    }

    public static <V extends Message, X extends Message.Builder> PStoreConfigBuilder<V> newProtoBuilder(Schema<V> writeSchema, Schema<X> readSchema) {
        return new PStoreConfigBuilder(new ProtoSerializer<V, X>(writeSchema, readSchema));
    }

    public static <V> PStoreConfigBuilder<V> newJacksonBuilder(ObjectMapper mapper, Class<V> clazz) {
        return new PStoreConfigBuilder<V>(new JacksonSerializer<V>(mapper, clazz));
    }

    public static class PStoreConfigBuilder<V> {
        String name;
        PClassSerializer<V> serializer;
        Mode mode = Mode.PERSISTENT;
        int maxIteratorSize = Integer.MAX_VALUE;

        PStoreConfigBuilder(PClassSerializer<V> serializer) {
            this.serializer = serializer;
        }

        public PStoreConfigBuilder<V> name(String name) {
            this.name = name;
            return this;
        }

        public PStoreConfigBuilder<V> ephemeral() {
            this.mode = Mode.EPHEMERAL;
            return this;
        }

        public PStoreConfigBuilder<V> blob() {
            this.mode = Mode.BLOB_PERSISTENT;
            return this;
        }

        public PStoreConfigBuilder<V> max(int size) {
            this.maxIteratorSize = size;
            return this;
        }

        public PStoreConfig<V> build() {
            Preconditions.checkNotNull(this.name);
            return new PStoreConfig(this.name, this.serializer, this.mode, this.maxIteratorSize);
        }
    }

    public static enum Mode {
        PERSISTENT,
        EPHEMERAL,
        BLOB_PERSISTENT;

    }
}

