/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Iterator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillbitIterator
implements Iterator<Object> {
    static final Logger logger = LoggerFactory.getLogger(DrillbitIterator.class);
    private Iterator<CoordinationProtos.DrillbitEndpoint> endpoints;
    private CoordinationProtos.DrillbitEndpoint current;

    @Override
    public boolean hasNext() {
        return this.endpoints.hasNext();
    }

    @Override
    public Object next() {
        CoordinationProtos.DrillbitEndpoint ep = this.endpoints.next();
        DrillbitInstance i = new DrillbitInstance();
        i.current = ep.equals(this.current);
        i.host = ep.getAddress();
        i.user_port = ep.getUserPort();
        i.control_port = ep.getControlPort();
        i.data_port = ep.getDataPort();
        return i;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class DrillbitInstance {
        public String host;
        public int user_port;
        public int control_port;
        public int data_port;
        public boolean current;
    }
}

