/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.ischema.InfoSchemaTable;
import org.apache.drill.exec.store.ischema.RecordGenerator;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

public enum SelectedTable {
    CATALOGS(new InfoSchemaTable.Catalogs()),
    SCHEMATA(new InfoSchemaTable.Schemata()),
    VIEWS(new InfoSchemaTable.Views()),
    COLUMNS(new InfoSchemaTable.Columns()),
    TABLES(new InfoSchemaTable.Tables());

    private final InfoSchemaTable tableDef;

    private SelectedTable(InfoSchemaTable tableDef) {
        this.tableDef = tableDef;
    }

    public RecordReader getRecordReader(SchemaPlus rootSchema) {
        RecordGenerator recordGenerator = this.tableDef.getRecordGenerator();
        recordGenerator.scanSchema(rootSchema);
        return recordGenerator.getRecordReader();
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.tableDef.getRowType(typeFactory);
    }
}

