/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import org.apache.drill.exec.planner.logical.DrillViewInfoProvider;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.ischema.Records;
import org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;

public abstract class RecordGenerator {
    public boolean visitSchema(String schemaName, SchemaPlus schema) {
        return this.shouldVisitSchema(schema);
    }

    public boolean visitTable(String schemaName, String tableName, Table table) {
        return true;
    }

    public boolean visitField(String schemaName, String tableName, RelDataTypeField field) {
        return true;
    }

    protected boolean shouldVisitSchema(SchemaPlus schema) {
        try {
            AbstractSchema drillSchema = schema.unwrap(AbstractSchema.class);
            return drillSchema.showInInformationSchema();
        }
        catch (ClassCastException classCastException) {
            return true;
        }
    }

    public abstract RecordReader getRecordReader();

    public void scanSchema(SchemaPlus root) {
        this.scanSchema(root.getName(), root);
    }

    private void scanSchema(String schemaPath, SchemaPlus schema) {
        for (String name : schema.getSubSchemaNames()) {
            this.scanSchema(schemaPath + (schemaPath == "" ? "" : ".") + name, schema.getSubSchema(name));
        }
        if (this.visitSchema(schemaPath, schema)) {
            for (String tableName : schema.getTableNames()) {
                Table table;
                if (!this.visitTable(schemaPath, tableName, table = schema.getTable(tableName))) continue;
                RelDataType tableRow = table.getRowType(new JavaTypeFactoryImpl());
                for (RelDataTypeField field : tableRow.getFieldList()) {
                    this.visitField(schemaPath, tableName, field);
                }
            }
        }
    }

    public static class Columns
    extends RecordGenerator {
        List<Records.Column> records = Lists.newArrayList();

        @Override
        public RecordReader getRecordReader() {
            return new PojoRecordReader<Records.Column>(Records.Column.class, this.records.iterator());
        }

        @Override
        public boolean visitField(String schemaName, String tableName, RelDataTypeField field) {
            this.records.add(new Records.Column("DRILL", schemaName, tableName, field));
            return false;
        }
    }

    public static class Views
    extends RecordGenerator {
        List<Records.View> records = Lists.newArrayList();

        @Override
        public RecordReader getRecordReader() {
            return new PojoRecordReader<Records.View>(Records.View.class, this.records.iterator());
        }

        @Override
        public boolean visitTable(String schemaName, String tableName, Table table) {
            if (table.getJdbcTableType() == Schema.TableType.VIEW) {
                this.records.add(new Records.View("DRILL", schemaName, tableName, ((DrillViewInfoProvider)((Object)table)).getViewSql()));
            }
            return false;
        }
    }

    public static class Tables
    extends RecordGenerator {
        List<Records.Table> records = Lists.newArrayList();

        @Override
        public RecordReader getRecordReader() {
            return new PojoRecordReader<Records.Table>(Records.Table.class, this.records.iterator());
        }

        @Override
        public boolean visitTable(String schemaName, String tableName, Table table) {
            this.records.add(new Records.Table("DRILL", schemaName, tableName, table.getJdbcTableType().toString()));
            return false;
        }
    }

    public static class Schemata
    extends RecordGenerator {
        List<Records.Schema> records = Lists.newArrayList();

        @Override
        public RecordReader getRecordReader() {
            return new PojoRecordReader<Records.Schema>(Records.Schema.class, this.records.iterator());
        }

        @Override
        public boolean visitSchema(String schemaName, SchemaPlus schema) {
            if (this.shouldVisitSchema(schema) && schemaName != null && !schemaName.isEmpty()) {
                AbstractSchema as = schema.unwrap(AbstractSchema.class);
                this.records.add(new Records.Schema("DRILL", schemaName, "<owner>", as.getTypeName(), as.isMutable()));
            }
            return false;
        }
    }

    public static class Catalogs
    extends RecordGenerator {
        @Override
        public RecordReader getRecordReader() {
            Records.Catalog catalogRecord = new Records.Catalog("DRILL", "The internal metadata used by Drill", "");
            return new PojoRecordReader<Records.Catalog>(Records.Catalog.class, ImmutableList.of(catalogRecord).iterator());
        }
    }
}

