/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import java.io.IOException;
import java.io.InputStream;

public class RewindableUtf8Reader<T extends InputStream>
extends UTF8StreamJsonParser {
    private long markFilePos;
    private int markInputPtr;
    private int markInputEnd;
    private long markInputProcessed;
    private int markInputRow;
    private int markInputRowStart;
    private long markInputTotal;
    private int markTokenInputRow;
    private int markTokenInputCol;
    private JsonToken markToken;
    private JsonToken markLastToken;
    private JsonReadContext markContext;
    private JsonReadContext rootContext = this._parsingContext;
    private int type;
    private int lineNr;
    private int colNr;
    private boolean closed = false;

    public RewindableUtf8Reader(IOContext ctxt, int features, BytesToNameCanonicalizer sym, byte[] inputBuffer) {
        super(ctxt, features, null, null, sym, inputBuffer, 0, 0, true);
    }

    @Override
    protected void _closeInput() throws IOException {
        super._closeInput();
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
        this.closed = true;
    }

    public String toString() {
        return "RewindableUtf8Reader [markFilePos=" + this.markFilePos + ", markInputPtr=" + this.markInputPtr + ", markInputEnd=" + this.markInputEnd + ", markInputProcessed=" + this.markInputProcessed + ", markInputRow=" + this.markInputRow + ", markInputRowStart=" + this.markInputRowStart + ", markInputTotal=" + this.markInputTotal + ", markTokenInputRow=" + this.markTokenInputRow + ", markTokenInputCol=" + this.markTokenInputCol + ", markToken=" + (Object)((Object)this.markToken) + ", markLastToken=" + (Object)((Object)this.markLastToken) + ", markContext=" + this.markContext + ", rootContext=" + this.rootContext + ", type=" + this.type + ", lineNr=" + this.lineNr + ", colNr=" + this.colNr + "]";
    }
}

