/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.direct;

import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.RecordReader;
import org.apache.drill.exec.store.direct.DirectSubScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectGroupScan
extends AbstractGroupScan {
    static final Logger logger = LoggerFactory.getLogger(DirectGroupScan.class);
    private final RecordReader reader;

    public DirectGroupScan(RecordReader reader) {
        this.reader = reader;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) throws PhysicalOperatorSetupException {
        assert (endpoints.size() == 1);
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        assert (minorFragmentId == 0);
        return new DirectSubScan(this.reader);
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public ScanStats getScanStats() {
        return ScanStats.TRIVIAL_TABLE;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        assert (children == null || children.isEmpty());
        return new DirectGroupScan(this.reader);
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        return Collections.emptyList();
    }

    @Override
    public String getDigest() {
        return String.valueOf(this.reader);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return this;
    }
}

