/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs.shim.fallback;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.store.dfs.DrillPathFilter;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.drill.exec.store.dfs.shim.DrillInputStream;
import org.apache.drill.exec.store.dfs.shim.DrillOutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackFileSystem
extends DrillFileSystem {
    static final Logger logger = LoggerFactory.getLogger(FallbackFileSystem.class);
    final FileSystem fs;

    public FallbackFileSystem(DrillConfig config, FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public FileSystem getUnderlying() {
        return this.fs;
    }

    @Override
    public List<FileStatus> list(boolean recursive, Path ... paths) throws IOException {
        if (recursive) {
            ArrayList<FileStatus> statuses = Lists.newArrayList();
            for (Path p : paths) {
                this.addRecursiveStatus(this.fs.getFileStatus(p), statuses);
            }
            return statuses;
        }
        return Lists.newArrayList(this.fs.listStatus(paths));
    }

    private void addRecursiveStatus(FileStatus parent, List<FileStatus> listToFill) throws IOException {
        if (parent.isDir()) {
            FileStatus[] sub;
            Path pattern = new Path(parent.getPath(), "*");
            for (FileStatus s : sub = this.fs.globStatus(pattern, (PathFilter)new DrillPathFilter())) {
                if (s.isDir()) {
                    this.addRecursiveStatus(s, listToFill);
                    continue;
                }
                listToFill.add(s);
            }
        } else {
            listToFill.add(parent);
        }
    }

    @Override
    public FileStatus getFileStatus(Path p) throws IOException {
        return this.fs.getFileStatus(p);
    }

    @Override
    public DrillOutputStream create(Path p) throws IOException {
        return new Out(this.fs.create(p));
    }

    @Override
    public DrillInputStream open(Path p) throws IOException {
        return new In(this.fs.open(p));
    }

    @Override
    public void close() throws Exception {
        this.fs.close();
    }

    private class In
    extends DrillInputStream {
        private final FSDataInputStream in;

        public In(FSDataInputStream in) {
            this.in = in;
        }

        @Override
        public FSDataInputStream getInputStream() {
            return this.in;
        }

        @Override
        public void close() throws Exception {
            this.in.close();
        }
    }

    private class Out
    extends DrillOutputStream {
        private final FSDataOutputStream out;

        public Out(FSDataOutputStream out) {
            this.out = out;
        }

        @Override
        public void close() throws Exception {
            this.out.close();
        }

        public FSDataOutputStream getOuputStream() {
            return this.out;
        }
    }
}

