/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.Table;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.dotdrill.DotDrillFile;
import org.apache.drill.exec.dotdrill.DotDrillType;
import org.apache.drill.exec.dotdrill.DotDrillUtil;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillViewTable;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.planner.logical.FileSystemCreateTableEntry;
import org.apache.drill.exec.planner.sql.ExpandingConcurrentMap;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.WorkspaceConfig;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.drill.exec.store.dfs.shim.DrillOutputStream;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceSchemaFactory
implements ExpandingConcurrentMap.MapValueFactory<String, DrillTable> {
    static final Logger logger = LoggerFactory.getLogger(WorkspaceSchemaFactory.class);
    private final List<FormatMatcher> fileMatchers;
    private final List<FormatMatcher> dirMatchers;
    private final WorkspaceConfig config;
    private final DrillFileSystem fs;
    private final DrillConfig drillConfig;
    private final String storageEngineName;
    private final String schemaName;
    private final FileSystemPlugin plugin;
    private final PStore<String> knownViews;
    private final ObjectMapper mapper;

    private Path getViewPath(String name) {
        return new Path(this.config.getLocation() + '/' + name + ".view.drill");
    }

    public WorkspaceSchema createSchema(List<String> parentSchemaPath, UserSession session) {
        return new WorkspaceSchema(parentSchemaPath, this.schemaName, session);
    }

    public DrillTable create(String key) {
        try {
            FormatSelection selection;
            FileSelection fileSelection = FileSelection.create(this.fs, this.config.getLocation(), key);
            if (fileSelection == null) {
                return null;
            }
            if (fileSelection.containsDirectories(this.fs)) {
                for (FormatMatcher m : this.dirMatchers) {
                    try {
                        selection = m.isReadable(fileSelection);
                        if (selection == null) continue;
                        return new DynamicDrillTable(this.plugin, this.storageEngineName, (Object)selection);
                    }
                    catch (IOException e) {
                        logger.debug("File read failed.", e);
                    }
                }
                fileSelection = fileSelection.minusDirectories(this.fs);
            }
            for (FormatMatcher m : this.fileMatchers) {
                selection = m.isReadable(fileSelection);
                if (selection == null) continue;
                return new DynamicDrillTable(this.plugin, this.storageEngineName, (Object)selection);
            }
            return null;
        }
        catch (IOException e) {
            logger.debug("Failed to create DrillTable with root {} and name {}", this.config.getLocation(), key, e);
            return null;
        }
    }

    public void destroy(DrillTable value) {
    }

    public class WorkspaceSchema
    extends AbstractSchema {
        private ExpandingConcurrentMap<String, DrillTable> tables;
        private UserSession session;

        public boolean createView(View view) throws Exception {
            Path viewPath = WorkspaceSchemaFactory.this.getViewPath(view.getName());
            boolean replaced = WorkspaceSchemaFactory.this.fs.getUnderlying().exists(viewPath);
            try (DrillOutputStream stream = WorkspaceSchemaFactory.this.fs.create(viewPath);){
                WorkspaceSchemaFactory.this.mapper.writeValue(stream.getOuputStream(), (Object)view);
            }
            if (WorkspaceSchemaFactory.this.knownViews != null) {
                WorkspaceSchemaFactory.this.knownViews.put(view.getName(), viewPath.toString());
            }
            return replaced;
        }

        public boolean viewExists(String viewName) throws Exception {
            Path viewPath = WorkspaceSchemaFactory.this.getViewPath(viewName);
            return WorkspaceSchemaFactory.this.fs.getUnderlying().exists(viewPath);
        }

        public void dropView(String viewName) throws IOException {
            WorkspaceSchemaFactory.this.fs.getUnderlying().delete(WorkspaceSchemaFactory.this.getViewPath(viewName), false);
            if (WorkspaceSchemaFactory.this.knownViews != null) {
                WorkspaceSchemaFactory.this.knownViews.delete(viewName);
            }
        }

        public WorkspaceSchema(List<String> parentSchemaPath, String name, UserSession session) {
            super(parentSchemaPath, name);
            this.tables = new ExpandingConcurrentMap<String, DrillTable>(WorkspaceSchemaFactory.this);
            this.session = session;
        }

        private Set<String> getViews() {
            HashSet<String> viewSet = Sets.newHashSet();
            if (WorkspaceSchemaFactory.this.knownViews != null) {
                for (Map.Entry e : WorkspaceSchemaFactory.this.knownViews) {
                    String viewName = (String)e.getKey();
                    if (this.hasView(viewName)) {
                        viewSet.add(viewName);
                        continue;
                    }
                    if (WorkspaceSchemaFactory.this.knownViews == null) continue;
                    WorkspaceSchemaFactory.this.knownViews.delete(viewName);
                }
            }
            return viewSet;
        }

        public boolean hasView(String viewName) {
            List<DotDrillFile> files = null;
            try {
                files = DotDrillUtil.getDotDrills(WorkspaceSchemaFactory.this.fs, new Path(WorkspaceSchemaFactory.this.config.getLocation()), viewName, DotDrillType.VIEW);
            }
            catch (Exception e) {
                logger.warn("Failure while trying to check view[{}].", (Object)viewName, (Object)e);
            }
            return files != null && files.size() > 0;
        }

        @Override
        public Set<String> getTableNames() {
            return Sets.union(this.tables.keySet(), this.getViews());
        }

        private View getView(DotDrillFile f) throws Exception {
            assert (f.getType() == DotDrillType.VIEW);
            return f.getView(WorkspaceSchemaFactory.this.drillConfig);
        }

        @Override
        public Table getTable(String name) {
            if (this.tables.alreadyContainsKey(name)) {
                return this.tables.get(name);
            }
            try {
                List<DotDrillFile> files = DotDrillUtil.getDotDrills(WorkspaceSchemaFactory.this.fs, new Path(WorkspaceSchemaFactory.this.config.getLocation()), name, DotDrillType.VIEW);
                for (DotDrillFile f : files) {
                    switch (f.getType()) {
                        case VIEW: {
                            return new DrillViewTable(this.schemaPath, this.getView(f));
                        }
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                logger.debug("The filesystem for this workspace does not support this operation.", e);
            }
            catch (Exception e) {
                logger.warn("Failure while trying to load .drill file.", e);
            }
            return this.tables.get(name);
        }

        @Override
        public boolean isMutable() {
            return WorkspaceSchemaFactory.this.config.isWritable();
        }

        public DrillFileSystem getFS() {
            return WorkspaceSchemaFactory.this.fs;
        }

        public String getDefaultLocation() {
            return WorkspaceSchemaFactory.this.config.getLocation();
        }

        @Override
        public CreateTableEntry createNewTable(String tableName) {
            String storage = this.session.getOptions().getOption((String)"store.format").string_val;
            FormatPlugin formatPlugin = WorkspaceSchemaFactory.this.plugin.getFormatPlugin(storage);
            if (formatPlugin == null) {
                throw new UnsupportedOperationException(String.format("Unsupported format '%s' in workspace '%s'", WorkspaceSchemaFactory.this.config.getDefaultInputFormat(), Joiner.on(".").join(this.getSchemaPath())));
            }
            return new FileSystemCreateTableEntry((FileSystemConfig)WorkspaceSchemaFactory.this.plugin.getConfig(), formatPlugin, WorkspaceSchemaFactory.this.config.getLocation() + "/" + tableName);
        }

        @Override
        public String getTypeName() {
            return "file";
        }
    }
}

