/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FileSystemSchemaFactory;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.NamedFormatPluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPlugin
extends AbstractStoragePlugin {
    static final Logger logger = LoggerFactory.getLogger(FileSystemPlugin.class);
    private final FileSystemSchemaFactory schemaFactory;
    private Map<String, FormatPlugin> formatPluginsByName;
    private Map<FormatPluginConfig, FormatPlugin> formatPluginsByConfig;
    private FileSystemConfig config;
    private DrillbitContext context;

    @Override
    public StoragePluginConfig getConfig() {
        return this.config;
    }

    @Override
    public AbstractGroupScan getPhysicalScan(JSONOptions selection, List<SchemaPath> columns) throws IOException {
        FormatSelection formatSelection = selection.getWith(this.context.getConfig(), FormatSelection.class);
        FormatPlugin plugin = formatSelection.getFormat() instanceof NamedFormatPluginConfig ? this.formatPluginsByName.get(((NamedFormatPluginConfig)formatSelection.getFormat()).name) : this.formatPluginsByConfig.get(formatSelection.getFormat());
        if (plugin == null) {
            throw new IOException(String.format("Failure getting requested format plugin named '%s'.  It was not one of the format plugins registered.", formatSelection.getFormat()));
        }
        return plugin.getGroupScan(formatSelection.getSelection(), columns);
    }

    @Override
    public void registerSchemas(UserSession session, SchemaPlus parent) {
        this.schemaFactory.registerSchemas(session, parent);
    }

    public FormatPlugin getFormatPlugin(String name) {
        return this.formatPluginsByName.get(name);
    }

    @Override
    public Set<Object> getOptimizerRules() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (FormatPlugin plugin : this.formatPluginsByName.values()) {
            Set<Object> rules = plugin.getOptimizerRules();
            if (rules == null || rules.size() <= 0) continue;
            setBuilder.addAll(rules);
        }
        return setBuilder.build();
    }
}

