/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.hydromatic.linq4j.expressions.DefaultExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchema
implements Schema {
    static final Logger logger = LoggerFactory.getLogger(AbstractSchema.class);
    protected final List<String> schemaPath = Lists.newArrayList();
    protected final String name;
    private static final Expression EXPRESSION = new DefaultExpression(Object.class);

    public AbstractSchema(List<String> parentSchemaPath, String name) {
        this.schemaPath.addAll(parentSchemaPath);
        this.schemaPath.add(name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public String getFullSchemaName() {
        return Joiner.on(".").join(this.schemaPath);
    }

    public abstract String getTypeName();

    public AbstractSchema getDefaultSchema() {
        return this;
    }

    public CreateTableEntry createNewTable(String tableName) {
        throw new UnsupportedOperationException("New tables are not allowed in this schema");
    }

    public boolean showInInformationSchema() {
        return true;
    }

    @Override
    public Schema getSubSchema(String name) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return Collections.emptySet();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Table getTable(String name) {
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return EXPRESSION;
    }
}

