/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.service;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.TransportCheck;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.rpc.control.ControllerImpl;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.DataConnectionCreator;
import org.apache.drill.exec.rpc.data.DataResponseHandler;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEngine
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    private final UserServer userServer;
    private final Controller controller;
    private final DataConnectionCreator dataPool;
    private final DrillConfig config;
    boolean useIP = false;
    private final boolean allowPortHunting;

    public ServiceEngine(ControlMessageHandler controlMessageHandler, UserWorker userWorker, BootStrapContext context, WorkEventBus workBus, DataResponseHandler dataHandler, boolean allowPortHunting) {
        this.userServer = new UserServer(context.getAllocator(), TransportCheck.createEventLoopGroup(context.getConfig().getInt("drill.exec.rpc.user.server.threads"), "UserServer-"), userWorker);
        this.controller = new ControllerImpl(context, controlMessageHandler, allowPortHunting);
        this.dataPool = new DataConnectionCreator(context, workBus, dataHandler, allowPortHunting);
        this.config = context.getConfig();
        this.allowPortHunting = allowPortHunting;
    }

    public CoordinationProtos.DrillbitEndpoint start() throws DrillbitStartupException, InterruptedException, UnknownHostException {
        int userPort = this.userServer.bind(this.config.getInt("drill.exec.rpc.user.server.port"), this.allowPortHunting);
        String address = this.useIP ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getLocalHost().getCanonicalHostName();
        CoordinationProtos.DrillbitEndpoint partialEndpoint = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(address).setUserPort(userPort).build();
        partialEndpoint = this.controller.start(partialEndpoint);
        return this.dataPool.start(partialEndpoint);
    }

    public DataConnectionCreator getDataConnectionCreator() {
        return this.dataPool;
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public void close() throws IOException {
        Closeables.closeQuietly(this.userServer);
        Closeables.closeQuietly(this.dataPool);
        Closeables.closeQuietly(this.controller);
    }
}

