/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import javax.ws.rs.RuntimeType;
import org.apache.drill.exec.server.rest.DrillRoot;
import org.apache.drill.exec.server.rest.MetricsResources;
import org.apache.drill.exec.server.rest.ProfileResources;
import org.apache.drill.exec.server.rest.QueryResources;
import org.apache.drill.exec.server.rest.StatusResources;
import org.apache.drill.exec.server.rest.StorageResources;
import org.apache.drill.exec.server.rest.ThreadsResources;
import org.apache.drill.exec.work.WorkManager;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillRestServer
extends ResourceConfig {
    static final Logger logger = LoggerFactory.getLogger(DrillRestServer.class);

    public DrillRestServer(final WorkManager workManager) {
        this.register(DrillRoot.class);
        this.register(StatusResources.class);
        this.register(StorageResources.class);
        this.register(ProfileResources.class);
        this.register(QueryResources.class);
        this.register(MetricsResources.class);
        this.register(ThreadsResources.class);
        this.register(FreemarkerMvcFeature.class);
        this.register(MultiPartFeature.class);
        this.property("jersey.config.server.disableMetainfServicesLookup", true);
        String disableMoxy = PropertiesHelper.getPropertyNameForRuntime((String)"jersey.config.disableMoxyJson", (RuntimeType)this.getConfiguration().getRuntimeType());
        this.property(disableMoxy, true);
        this.register(JsonParseExceptionMapper.class);
        this.register(JsonMappingExceptionMapper.class);
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(workManager.getContext().getConfig().getMapper());
        this.register(provider);
        this.register(new AbstractBinder(){});
    }
}

