/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import java.math.BigDecimal;
import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.util.NlsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeValidators {
    static final Logger logger = LoggerFactory.getLogger(TypeValidators.class);

    public static OptionValue getPartialValue(String name, OptionValue.OptionType type, SqlLiteral literal) {
        switch (literal.getTypeName()) {
            case DECIMAL: {
                if (((BigDecimal)literal.getValue()).scale() == 0) {
                    return OptionValue.createLong(type, name, ((BigDecimal)literal.getValue()).longValue());
                }
                return OptionValue.createDouble(type, name, ((BigDecimal)literal.getValue()).doubleValue());
            }
            case DOUBLE: 
            case FLOAT: {
                return OptionValue.createDouble(type, name, ((BigDecimal)literal.getValue()).doubleValue());
            }
            case SMALLINT: 
            case TINYINT: 
            case BIGINT: 
            case INTEGER: {
                return OptionValue.createLong(type, name, ((BigDecimal)literal.getValue()).longValue());
            }
            case VARBINARY: 
            case VARCHAR: 
            case CHAR: {
                return OptionValue.createString(type, name, ((NlsString)literal.getValue()).getValue());
            }
            case BOOLEAN: {
                return OptionValue.createBoolean(type, name, (Boolean)literal.getValue());
            }
        }
        throw new ExpressionParsingException(String.format("Drill doesn't support set option expressions with literals of type %s.", new Object[]{literal.getTypeName()}));
    }

    public static abstract class TypeValidator
    extends OptionValidator {
        final OptionValue.Kind kind;
        private OptionValue defaultValue;

        public TypeValidator(String name, OptionValue.Kind kind, OptionValue defValue) {
            super(name);
            this.kind = kind;
            this.defaultValue = defValue;
        }

        @Override
        public OptionValue getDefault() {
            return this.defaultValue;
        }

        @Override
        public OptionValue validate(SqlLiteral value) throws ExpressionParsingException {
            OptionValue op = TypeValidators.getPartialValue(this.getOptionName(), null, value);
            this.validate(op);
            return op;
        }

        @Override
        public void validate(OptionValue v) throws ExpressionParsingException {
            if (v.kind != this.kind) {
                throw new ExpressionParsingException(String.format("Option %s must be of type %s but you tried to set to %s.", this.getOptionName(), this.kind.name(), v.kind.name()));
            }
        }
    }

    public static class RangeLongValidator
    extends LongValidator {
        private final long min;
        private final long max;

        public RangeLongValidator(String name, long min, long max, long def) {
            super(name, def);
            this.min = min;
            this.max = max;
        }

        @Override
        public void validate(OptionValue v) throws ExpressionParsingException {
            super.validate(v);
            if (v.num_val > this.max || v.num_val < this.min) {
                throw new ExpressionParsingException(String.format("Option %s must be between %d and %d.", this.getOptionName(), this.min, this.max));
            }
        }
    }

    public static class DoubleValidator
    extends TypeValidator {
        public DoubleValidator(String name, double def) {
            super(name, OptionValue.Kind.DOUBLE, OptionValue.createDouble(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class LongValidator
    extends TypeValidator {
        public LongValidator(String name, long def) {
            super(name, OptionValue.Kind.LONG, OptionValue.createLong(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class StringValidator
    extends TypeValidator {
        public StringValidator(String name, String def) {
            super(name, OptionValue.Kind.STRING, OptionValue.createString(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class BooleanValidator
    extends TypeValidator {
        public BooleanValidator(String name, boolean def) {
            super(name, OptionValue.Kind.BOOLEAN, OptionValue.createBoolean(OptionValue.OptionType.SYSTEM, name, def));
        }
    }

    public static class RangeDoubleValidator
    extends DoubleValidator {
        private final double min;
        private final double max;

        public RangeDoubleValidator(String name, double min, double max, double def) {
            super(name, def);
            this.min = min;
            this.max = max;
        }

        @Override
        public void validate(OptionValue v) throws ExpressionParsingException {
            super.validate(v);
            if (v.float_val > this.max || v.float_val < this.min) {
                throw new ExpressionParsingException(String.format("Option %s must be between %d and %d.", this.getOptionName(), this.min, this.max));
            }
        }
    }

    public static class PowerOfTwoLongValidator
    extends PositiveLongValidator {
        public PowerOfTwoLongValidator(String name, long max, long def) {
            super(name, max, def);
        }

        @Override
        public void validate(OptionValue v) throws ExpressionParsingException {
            super.validate(v);
            if (!this.isPowerOfTwo(v.num_val)) {
                throw new ExpressionParsingException(String.format("Option %s must be a power of two.", this.getOptionName()));
            }
        }

        private boolean isPowerOfTwo(long num) {
            return (num & num - 1L) == 0L;
        }
    }

    public static class PositiveLongValidator
    extends LongValidator {
        private final long max;

        public PositiveLongValidator(String name, long max, long def) {
            super(name, def);
            this.max = max;
        }

        @Override
        public void validate(OptionValue v) throws ExpressionParsingException {
            super.validate(v);
            if (v.num_val > this.max || v.num_val < 0L) {
                throw new ExpressionParsingException(String.format("Option %s must be between %d and %d.", this.getOptionName(), 0, this.max));
            }
        }
    }
}

