/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.IteratorUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SetOptionException;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.eigenbase.sql.SqlLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOptionManager
implements OptionManager {
    static final Logger logger = LoggerFactory.getLogger(SystemOptionManager.class);
    private final OptionValidator[] VALIDATORS = new OptionValidator[]{PlannerSettings.EXCHANGE, PlannerSettings.HASHAGG, PlannerSettings.STREAMAGG, PlannerSettings.HASHJOIN, PlannerSettings.MERGEJOIN, PlannerSettings.MULTIPHASE, PlannerSettings.BROADCAST, PlannerSettings.BROADCAST_THRESHOLD, PlannerSettings.JOIN_ROW_COUNT_ESTIMATE_FACTOR, PlannerSettings.PRODUCER_CONSUMER, PlannerSettings.PRODUCER_CONSUMER_QUEUE_SIZE, PlannerSettings.HASH_SINGLE_KEY, PlannerSettings.IDENTIFIER_MAX_LENGTH, ExecConstants.OUTPUT_FORMAT_VALIDATOR, ExecConstants.PARQUET_BLOCK_SIZE_VALIDATOR, ExecConstants.PARQUET_VECTOR_FILL_THRESHOLD_VALIDATOR, ExecConstants.PARQUET_VECTOR_FILL_CHECK_THRESHOLD_VALIDATOR, ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR, ExecConstants.JSON_READER_ALL_TEXT_MODE_VALIDATOR, ExecConstants.FILESYSTEM_PARTITION_COLUMN_LABEL_VALIDATOR, ExecConstants.MONGO_READER_ALL_TEXT_MODE_VALIDATOR, ExecConstants.SLICE_TARGET_OPTION, ExecConstants.AFFINITY_FACTOR, ExecConstants.MAX_WIDTH_GLOBAL, ExecConstants.MAX_WIDTH_PER_NODE, ExecConstants.ENABLE_QUEUE, ExecConstants.LARGE_QUEUE_SIZE, ExecConstants.QUEUE_THRESHOLD_SIZE, ExecConstants.QUEUE_TIMEOUT, ExecConstants.SMALL_QUEUE_SIZE, ExecConstants.MIN_HASH_TABLE_SIZE, ExecConstants.MAX_HASH_TABLE_SIZE, ExecConstants.ENABLE_MEMORY_ESTIMATION, ExecConstants.MAX_QUERY_MEMORY_PER_NODE, ExecConstants.NON_BLOCKING_OPERATORS_MEMORY, ExecConstants.HASH_JOIN_TABLE_FACTOR, ExecConstants.HASH_AGG_TABLE_FACTOR, ExecConstants.AVERAGE_FIELD_WIDTH, QueryClassLoader.JAVA_COMPILER_VALIDATOR, QueryClassLoader.JAVA_COMPILER_JANINO_MAXSIZE, QueryClassLoader.JAVA_COMPILER_DEBUG, ExecConstants.ENABLE_VERBOSE_ERRORS};
    public final PStoreConfig<OptionValue> config;
    private PStore<OptionValue> options;
    private SystemOptionAdmin admin;
    private final ConcurrentMap<String, OptionValidator> knownOptions = Maps.newConcurrentMap();
    private final PStoreProvider provider;

    public SystemOptionManager(DrillConfig config, PStoreProvider provider) {
        this.provider = provider;
        this.config = PStoreConfig.newJacksonBuilder(config.getMapper(), OptionValue.class).name("sys.options").build();
    }

    public SystemOptionManager init() throws IOException {
        this.options = this.provider.getStore(this.config);
        this.admin = new SystemOptionAdmin();
        return this;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        HashMap<String, OptionValue> buildList = Maps.newHashMap();
        for (OptionValidator optionValidator : this.knownOptions.values()) {
            buildList.put(optionValidator.getOptionName(), optionValidator.getDefault());
        }
        for (Map.Entry entry : this.options) {
            OptionValue value = (OptionValue)entry.getValue();
            buildList.put(value.name, value);
        }
        return buildList.values().iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue v = this.options.get(name);
        if (v != null) {
            return v;
        }
        OptionValidator validator = (OptionValidator)this.knownOptions.get(name);
        if (validator == null) {
            return null;
        }
        return validator.getDefault();
    }

    @Override
    public void setOption(OptionValue value) {
        assert (value.type == OptionValue.OptionType.SYSTEM);
        this.admin.validate(value);
        this.setOptionInternal(value);
    }

    private void setOptionInternal(OptionValue value) {
        if (!value.equals(this.knownOptions.get(value.name))) {
            this.options.put(value.name, value);
        }
    }

    @Override
    public void setOption(String name, SqlLiteral literal, OptionValue.OptionType type) {
        assert (type == OptionValue.OptionType.SYSTEM);
        OptionValue v = this.admin.validate(name, literal);
        v.type = type;
        this.setOptionInternal(v);
    }

    @Override
    public OptionList getOptionList() {
        return (OptionList)IteratorUtils.toList(this.iterator());
    }

    @Override
    public OptionManager.OptionAdmin getAdmin() {
        return this.admin;
    }

    private class SystemOptionAdmin
    implements OptionManager.OptionAdmin {
        public SystemOptionAdmin() {
            for (OptionValidator v : SystemOptionManager.this.VALIDATORS) {
                SystemOptionManager.this.knownOptions.put(v.getOptionName(), v);
            }
            for (Map.Entry v : SystemOptionManager.this.options) {
                OptionValue value = (OptionValue)v.getValue();
                OptionValidator defaultValidator = (OptionValidator)SystemOptionManager.this.knownOptions.get(v.getKey());
                if (defaultValidator == null) {
                    SystemOptionManager.this.options.delete(value.name);
                    logger.warn("Deleting deprecated option `{}`.", (Object)value.name);
                    continue;
                }
                if (!value.equals(defaultValidator)) continue;
                SystemOptionManager.this.options.delete(value.name);
                logger.warn("Deleting option `{}` set to default value.", (Object)value.name);
            }
        }

        @Override
        public void validate(OptionValue v) throws SetOptionException {
            OptionValidator validator = (OptionValidator)SystemOptionManager.this.knownOptions.get(v.name);
            if (validator == null) {
                throw new SetOptionException("Unknown option " + v.name);
            }
            validator.validate(v);
        }

        @Override
        public OptionValue validate(String name, SqlLiteral value) throws SetOptionException {
            OptionValidator validator = (OptionValidator)SystemOptionManager.this.knownOptions.get(name);
            if (validator == null) {
                throw new SetOptionException("Unknown option: " + name);
            }
            return validator.validate(value);
        }
    }
}

