/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import java.util.Map;
import org.apache.drill.exec.server.options.FallbackOptionManager;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InMemoryOptionManager
extends FallbackOptionManager {
    static final Logger logger = LoggerFactory.getLogger(InMemoryOptionManager.class);
    final Map<String, OptionValue> options;

    InMemoryOptionManager(OptionManager fallback, Map<String, OptionValue> options) {
        super(fallback);
        this.options = options;
    }

    @Override
    OptionValue getLocalOption(String name) {
        return this.options.get(name);
    }

    @Override
    boolean setLocalOption(OptionValue value) {
        if (this.supportsOption(value)) {
            this.options.put(value.name, value);
            return true;
        }
        return false;
    }

    @Override
    Iterable<OptionValue> optionIterable() {
        return this.options.values();
    }

    abstract boolean supportsOption(OptionValue var1);
}

