/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.eigenbase.sql.SqlLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FallbackOptionManager
implements OptionManager {
    static final Logger logger = LoggerFactory.getLogger(FallbackOptionManager.class);
    protected OptionManager fallback;

    public FallbackOptionManager(OptionManager fallback) {
        this.fallback = fallback;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return Iterables.concat(this.fallback, this.optionIterable()).iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue opt = this.getLocalOption(name);
        if (opt == null && this.fallback != null) {
            return this.fallback.getOption(name);
        }
        return opt;
    }

    abstract Iterable<OptionValue> optionIterable();

    abstract OptionValue getLocalOption(String var1);

    abstract boolean setLocalOption(OptionValue var1);

    @Override
    public void setOption(OptionValue value) {
        this.fallback.getAdmin().validate(value);
        this.setValidatedOption(value);
    }

    @Override
    public void setOption(String name, SqlLiteral literal, OptionValue.OptionType type) {
        OptionValue val = this.getAdmin().validate(name, literal);
        val.type = type;
        this.setValidatedOption(val);
    }

    private void setValidatedOption(OptionValue value) {
        if (!this.setLocalOption(value)) {
            this.fallback.setOption(value);
        } else {
            this.setLocalOption(value);
        }
    }

    @Override
    public OptionManager.OptionAdmin getAdmin() {
        return this.fallback.getAdmin();
    }

    @Override
    public OptionList getOptionList() {
        OptionList list = new OptionList();
        for (OptionValue o : this.optionIterable()) {
            list.add(o);
        }
        return list;
    }
}

