/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import com.codahale.metrics.MetricRegistry;
import io.netty.channel.EventLoopGroup;
import java.io.Closeable;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.TopLevelAllocator;
import org.apache.drill.exec.metrics.DrillMetrics;
import org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapContext
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(BootStrapContext.class);
    private final DrillConfig config;
    private final EventLoopGroup loop;
    private final EventLoopGroup loop2;
    private final MetricRegistry metrics;
    private final BufferAllocator allocator;

    public BootStrapContext(DrillConfig config) {
        this.config = config;
        this.loop = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitServer-");
        this.loop2 = TransportCheck.createEventLoopGroup(config.getInt("drill.exec.rpc.bit.server.threads"), "BitClient-");
        this.metrics = DrillMetrics.getInstance();
        this.allocator = new TopLevelAllocator(config);
    }

    public DrillConfig getConfig() {
        return this.config;
    }

    public EventLoopGroup getBitLoopGroup() {
        return this.loop;
    }

    public EventLoopGroup getBitClientLoopGroup() {
        return this.loop2;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void close() {
        this.loop.shutdownGracefully();
        this.allocator.close();
    }
}

