/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.BasicServer;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.user.UserProtobufLengthDecoder;
import org.apache.drill.exec.rpc.user.UserRpcConfig;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServer
extends BasicServer<UserProtos.RpcType, UserClientConnection> {
    static final Logger logger = LoggerFactory.getLogger(UserServer.class);
    final UserWorker worker;
    final BufferAllocator alloc;

    public UserServer(BufferAllocator alloc, EventLoopGroup eventLoopGroup, UserWorker worker) {
        super(UserRpcConfig.MAPPING, alloc.getUnderlyingAllocator(), eventLoopGroup);
        this.worker = worker;
        this.alloc = alloc;
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected Response handle(UserClientConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 3: {
                logger.debug("Received query to run.  Returning query handle.");
                try {
                    UserProtos.RunQuery query = UserProtos.RunQuery.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    return new Response(UserProtos.RpcType.QUERY_HANDLE, this.worker.submitWork(connection, query), new ByteBuf[0]);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding RunQuery body.", e);
                }
            }
            case 4: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    return new Response(UserProtos.RpcType.ACK, this.worker.cancelQuery(queryId), new ByteBuf[0]);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
        }
        throw new UnsupportedOperationException(String.format("UserServer received rpc of unknown type.  Type was %d.", rpcType));
    }

    @Override
    public UserClientConnection initRemoteConnection(Channel channel) {
        return new UserClientConnection(channel);
    }

    @Override
    protected BasicServer.ServerHandshakeHandler<UserProtos.UserToBitHandshake> getHandshakeHandler(final UserClientConnection connection) {
        return new BasicServer.ServerHandshakeHandler<UserProtos.UserToBitHandshake>((Internal.EnumLite)UserProtos.RpcType.HANDSHAKE, UserProtos.UserToBitHandshake.PARSER){

            @Override
            public MessageLite getHandshakeResponse(UserProtos.UserToBitHandshake inbound) throws Exception {
                logger.trace("Handling handshake from user to bit. {}", (Object)inbound);
                if (inbound.getRpcVersion() != UserRpcConfig.RPC_VERSION) {
                    throw new RpcException(String.format("Invalid rpc version. Expected %d, actual %d.", inbound.getRpcVersion(), UserRpcConfig.RPC_VERSION));
                }
                connection.setUser(inbound);
                return UserProtos.BitToUserHandshake.newBuilder().setRpcVersion(UserRpcConfig.RPC_VERSION).build();
            }
        };
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        return new UserProtobufLengthDecoder(allocator, outOfMemoryHandler);
    }

    public class UserClientConnection
    extends RemoteConnection {
        private UserSession session;

        public UserClientConnection(Channel channel) {
            super(channel);
        }

        void setUser(UserProtos.UserToBitHandshake inbound) throws IOException {
            this.session = UserSession.Builder.newBuilder().withCredentials(inbound.getCredentials()).withOptionManager(UserServer.this.worker.getSystemOptions()).withUserProperties(inbound.getProperties()).setSupportComplexTypes(inbound.getSupportComplexTypes()).build();
        }

        public UserSession getSession() {
            return this.session;
        }

        public void sendResult(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryWritableBatch result) {
            logger.trace("Sending result to client with {}", (Object)result);
            UserServer.this.send(listener, this, UserProtos.RpcType.QUERY_RESULT, result.getHeader(), GeneralRPCProtos.Ack.class, false, result.getBuffers());
        }

        public void sendResult(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryWritableBatch result, boolean allowInEventThread) {
            logger.trace("Sending result to client with {}", (Object)result);
            UserServer.this.send(listener, this, UserProtos.RpcType.QUERY_RESULT, result.getHeader(), GeneralRPCProtos.Ack.class, allowInEventThread, result.getBuffers());
        }

        @Override
        public BufferAllocator getAllocator() {
            return UserServer.this.alloc;
        }
    }
}

