/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.BasicServer;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.BitServerConnection;
import org.apache.drill.exec.rpc.data.DataDefaultInstanceHandler;
import org.apache.drill.exec.rpc.data.DataProtobufLengthDecoder;
import org.apache.drill.exec.rpc.data.DataResponseHandler;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServer
extends BasicServer<BitData.RpcType, BitServerConnection> {
    static final Logger logger = LoggerFactory.getLogger(DataServer.class);
    private volatile ProxyCloseHandler proxyCloseHandler;
    private final BootStrapContext context;
    private final WorkEventBus workBus;
    private final DataResponseHandler dataHandler;
    private static final BitData.FragmentRecordBatch OOM_FRAGMENT = BitData.FragmentRecordBatch.newBuilder().setIsOutOfMemory(true).build();

    public DataServer(BootStrapContext context, WorkEventBus workBus, DataResponseHandler dataHandler) {
        super(DataRpcConfig.MAPPING, context.getAllocator().getUnderlyingAllocator(), context.getBitLoopGroup());
        this.context = context;
        this.workBus = workBus;
        this.dataHandler = dataHandler;
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DataDefaultInstanceHandler.getResponseDefaultInstanceServer(rpcType);
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(BitServerConnection connection) {
        this.proxyCloseHandler = new ProxyCloseHandler(super.getCloseHandler(connection));
        return this.proxyCloseHandler;
    }

    @Override
    public BitServerConnection initRemoteConnection(Channel channel) {
        return new BitServerConnection(channel, this.context.getAllocator());
    }

    @Override
    protected BasicServer.ServerHandshakeHandler<BitData.BitClientHandshake> getHandshakeHandler(BitServerConnection connection) {
        return new BasicServer.ServerHandshakeHandler<BitData.BitClientHandshake>((Internal.EnumLite)BitData.RpcType.HANDSHAKE, BitData.BitClientHandshake.PARSER){

            @Override
            public MessageLite getHandshakeResponse(BitData.BitClientHandshake inbound) throws Exception {
                if (inbound.getRpcVersion() != DataRpcConfig.RPC_VERSION) {
                    throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", inbound.getRpcVersion(), DataRpcConfig.RPC_VERSION));
                }
                if (inbound.getChannel() != UserBitShared.RpcChannel.BIT_DATA) {
                    throw new RpcException(String.format("Invalid NodeMode.  Expected BIT_DATA but received %s.", inbound.getChannel()));
                }
                return BitData.BitServerHandshake.newBuilder().setRpcVersion(DataRpcConfig.RPC_VERSION).build();
            }
        };
    }

    @Override
    protected void handle(BitServerConnection connection, int rpcType, ByteBuf pBody, ByteBuf body, ResponseSender sender) throws RpcException {
        assert (rpcType == 3);
        BitData.FragmentRecordBatch fragmentBatch = DataServer.get(pBody, BitData.FragmentRecordBatch.PARSER);
        ExecProtos.FragmentHandle handle = fragmentBatch.getHandle();
        try {
            FragmentManager manager = this.workBus.getFragmentManager(fragmentBatch.getHandle());
            if (manager == null) {
                if (body != null) {
                    body.release();
                }
            } else {
                BufferAllocator allocator = manager.getFragmentContext().getAllocator();
                if (body != null && !manager.getFragmentContext().isCancelled() && !allocator.takeOwnership((DrillBuf)body.unwrap())) {
                    this.dataHandler.handle(connection, manager, OOM_FRAGMENT, null, null);
                }
                this.dataHandler.handle(connection, manager, fragmentBatch, (DrillBuf)body, sender);
            }
        }
        catch (FragmentSetupException e) {
            logger.error("Failure while getting fragment manager. {}", (Object)QueryIdHelper.getQueryIdentifier(handle), (Object)e);
            sender.send(new Response(BitData.RpcType.ACK, Acks.FAIL, new ByteBuf[0]));
        }
    }

    @Override
    public OutOfMemoryHandler getOutOfMemoryHandler() {
        return new OutOfMemoryHandler(){

            @Override
            public void handle() {
                DataServer.this.dataHandler.informOutOfMemory();
            }
        };
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        return new DataProtobufLengthDecoder(allocator, outOfMemoryHandler);
    }

    private class ProxyCloseHandler
    implements GenericFutureListener<ChannelFuture> {
        private volatile GenericFutureListener<ChannelFuture> handler;

        public ProxyCloseHandler(GenericFutureListener<ChannelFuture> handler) {
            this.handler = handler;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.handler.operationComplete(future);
        }
    }
}

