/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.data.DataClient;
import org.apache.drill.exec.rpc.data.DataClientConnection;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.apache.drill.exec.server.BootStrapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectionManager
extends ReconnectingConnection<DataClientConnection, BitData.BitClientHandshake> {
    static final Logger logger = LoggerFactory.getLogger(DataConnectionManager.class);
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final BootStrapContext context;

    public DataConnectionManager(ExecProtos.FragmentHandle handle, CoordinationProtos.DrillbitEndpoint endpoint, BootStrapContext context) {
        super(DataConnectionManager.hs(handle), endpoint.getAddress(), endpoint.getDataPort());
        this.endpoint = endpoint;
        this.context = context;
    }

    protected DataClient getNewClient() {
        return new DataClient(this.endpoint, this.context, new ReconnectingConnection.CloseHandlerCreator());
    }

    private static BitData.BitClientHandshake hs(ExecProtos.FragmentHandle handle) {
        return BitData.BitClientHandshake.newBuilder().setRpcVersion(DataRpcConfig.RPC_VERSION).setChannel(UserBitShared.RpcChannel.BIT_DATA).setHandle(handle).build();
    }
}

