/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.UUID;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.data.DataClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClientConnection
extends RemoteConnection {
    static final Logger logger = LoggerFactory.getLogger(DataClientConnection.class);
    private final DataClient client;
    private final UUID id;

    public DataClientConnection(Channel channel, DataClient client) {
        super(channel);
        this.client = client;
        this.id = UUID.randomUUID();
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.client.getAllocator();
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> outcomeListener, BitData.RpcType rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.client.send(outcomeListener, this, rpcType, protobufBody, clazz, dataBodies);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataClientConnection other = (DataClientConnection)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

