/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.FragmentStatusListener;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkEventBus {
    static final Logger logger = LoggerFactory.getLogger(WorkEventBus.class);
    private final ConcurrentMap<ExecProtos.FragmentHandle, FragmentManager> managers = Maps.newConcurrentMap();
    private final ConcurrentMap<UserBitShared.QueryId, FragmentStatusListener> listeners = new ConcurrentHashMap<UserBitShared.QueryId, FragmentStatusListener>(16, 0.75f, 16);
    private final WorkManager.WorkerBee bee;
    private final Cache<ExecProtos.FragmentHandle, Integer> recentlyFinishedFragments = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public WorkEventBus(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    public void removeFragmentStatusListener(UserBitShared.QueryId queryId) {
        logger.debug("Removing framgent status listener for queryId {}.", (Object)queryId);
        this.listeners.remove(queryId);
    }

    public void setFragmentStatusListener(UserBitShared.QueryId queryId, FragmentStatusListener listener) throws ForemanSetupException {
        logger.debug("Adding fragment status listener for queryId {}.", (Object)queryId);
        FragmentStatusListener old = this.listeners.putIfAbsent(queryId, listener);
        if (old != null) {
            throw new ForemanSetupException("Failure.  The provided handle already exists in the listener pool.  You need to remove one listener before adding another.");
        }
    }

    public void status(BitControl.FragmentStatus status) {
        FragmentStatusListener l = (FragmentStatusListener)this.listeners.get(status.getHandle().getQueryId());
        if (l == null) {
            logger.error("A fragment message arrived but there was no registered listener for that message for handle {}.", (Object)status.getHandle());
            return;
        }
        l.statusUpdate(status);
    }

    public void setFragmentManager(FragmentManager fragmentManager) {
        logger.debug("Manager created: {}", (Object)QueryIdHelper.getQueryIdentifier(fragmentManager.getHandle()));
        FragmentManager old = this.managers.putIfAbsent(fragmentManager.getHandle(), fragmentManager);
        if (old != null) {
            throw new IllegalStateException("Tried to set fragment manager when has already been set for the provided fragment handle.");
        }
    }

    public FragmentManager getFragmentManagerIfExists(ExecProtos.FragmentHandle handle) {
        return (FragmentManager)this.managers.get(handle);
    }

    public FragmentManager getFragmentManager(ExecProtos.FragmentHandle handle) throws FragmentSetupException {
        if (this.recentlyFinishedFragments.asMap().containsKey(handle)) {
            logger.debug("Fragment: {} was cancelled. Ignoring fragment handle", (Object)handle);
            return null;
        }
        FragmentManager m = (FragmentManager)this.managers.get(handle);
        if (m != null) {
            return m;
        }
        throw new FragmentSetupException("Failed to receive plan fragment that was required for id: " + QueryIdHelper.getQueryIdentifier(handle));
    }

    public void removeFragmentManager(ExecProtos.FragmentHandle handle) {
        logger.debug("Removing fragment manager: {}", (Object)QueryIdHelper.getQueryIdentifier(handle));
        this.recentlyFinishedFragments.put(handle, 1);
        this.managers.remove(handle);
    }
}

