/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.common.io.Closeables;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.control.ConnectionManagerRegistry;
import org.apache.drill.exec.rpc.control.ControlConnectionManager;
import org.apache.drill.exec.rpc.control.ControlServer;
import org.apache.drill.exec.rpc.control.ControlTunnel;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerImpl
implements Controller {
    static final Logger logger = LoggerFactory.getLogger(ControllerImpl.class);
    private volatile ControlServer server;
    private final ControlMessageHandler handler;
    private final BootStrapContext context;
    private final ConnectionManagerRegistry connectionRegistry;
    private final boolean allowPortHunting;

    public ControllerImpl(BootStrapContext context, ControlMessageHandler handler, boolean allowPortHunting) {
        this.handler = handler;
        this.context = context;
        this.connectionRegistry = new ConnectionManagerRegistry(handler, context);
        this.allowPortHunting = allowPortHunting;
    }

    @Override
    public CoordinationProtos.DrillbitEndpoint start(CoordinationProtos.DrillbitEndpoint partialEndpoint) throws InterruptedException, DrillbitStartupException {
        this.server = new ControlServer(this.handler, this.context, this.connectionRegistry);
        int port = this.context.getConfig().getInt("drill.exec.rpc.bit.server.port");
        port = this.server.bind(port, this.allowPortHunting);
        CoordinationProtos.DrillbitEndpoint completeEndpoint = partialEndpoint.toBuilder().setControlPort(port).build();
        this.connectionRegistry.setEndpoint(completeEndpoint);
        return completeEndpoint;
    }

    @Override
    public ControlTunnel getTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        return new ControlTunnel(endpoint, this.connectionRegistry.getConnectionManager(endpoint));
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.server);
        for (ControlConnectionManager bt : this.connectionRegistry) {
            bt.close();
        }
    }
}

