/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.FutureBitCommand;
import org.apache.drill.exec.rpc.ListeningCommand;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlTunnel {
    static final Logger logger = LoggerFactory.getLogger(ControlTunnel.class);
    private final ControlConnectionManager manager;
    private final CoordinationProtos.DrillbitEndpoint endpoint;

    public ControlTunnel(CoordinationProtos.DrillbitEndpoint endpoint, ControlConnectionManager manager) {
        this.manager = manager;
        this.endpoint = endpoint;
    }

    public void sendFragments(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, BitControl.InitializeFragments fragments) {
        SendFragment b = new SendFragment(outcomeListener, fragments);
        this.manager.runCommand(b);
    }

    public void cancelFragment(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, ExecProtos.FragmentHandle handle) {
        CancelFragment b = new CancelFragment(outcomeListener, handle);
        this.manager.runCommand(b);
    }

    public void informReceiverFinished(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, BitControl.FinishedReceiver finishedReceiver) {
        ReceiverFinished b = new ReceiverFinished(outcomeListener, finishedReceiver);
        this.manager.runCommand(b);
    }

    public DrillRpcFuture<GeneralRPCProtos.Ack> sendFragmentStatus(BitControl.FragmentStatus status) {
        SendFragmentStatus b = new SendFragmentStatus(status);
        this.manager.runCommand(b);
        return b.getFuture();
    }

    public static class SendFragment
    extends ListeningCommand<GeneralRPCProtos.Ack, ControlConnection> {
        final BitControl.InitializeFragments fragments;

        public SendFragment(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, BitControl.InitializeFragments fragments) {
            super(listener);
            this.fragments = fragments;
        }

        @Override
        public void doRpcCall(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, ControlConnection connection) {
            connection.send(outcomeListener, BitControl.RpcType.REQ_INIATILIZE_FRAGMENTS, this.fragments, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
        }
    }

    public static class CancelFragment
    extends ListeningCommand<GeneralRPCProtos.Ack, ControlConnection> {
        final ExecProtos.FragmentHandle handle;

        public CancelFragment(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, ExecProtos.FragmentHandle handle) {
            super(listener);
            this.handle = handle;
        }

        @Override
        public void doRpcCall(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, ControlConnection connection) {
            connection.sendUnsafe(outcomeListener, BitControl.RpcType.REQ_CANCEL_FRAGMENT, this.handle, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
        }
    }

    public static class ReceiverFinished
    extends ListeningCommand<GeneralRPCProtos.Ack, ControlConnection> {
        final BitControl.FinishedReceiver finishedReceiver;

        public ReceiverFinished(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, BitControl.FinishedReceiver finishedReceiver) {
            super(listener);
            this.finishedReceiver = finishedReceiver;
        }

        @Override
        public void doRpcCall(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, ControlConnection connection) {
            connection.send(outcomeListener, BitControl.RpcType.REQ_RECEIVER_FINISHED, this.finishedReceiver, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
        }
    }

    public static class SendFragmentStatus
    extends FutureBitCommand<GeneralRPCProtos.Ack, ControlConnection> {
        final BitControl.FragmentStatus status;

        public SendFragmentStatus(BitControl.FragmentStatus status) {
            this.status = status;
        }

        @Override
        public void doRpcCall(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, ControlConnection connection) {
            connection.sendUnsafe(outcomeListener, BitControl.RpcType.REQ_FRAGMENT_STATUS, this.status, GeneralRPCProtos.Ack.class, new ByteBuf[0]);
        }
    }
}

