/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.control.ControlClient;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlRpcConfig;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlConnectionManager
extends ReconnectingConnection<ControlConnection, BitControl.BitControlHandshake> {
    static final Logger logger = LoggerFactory.getLogger(ControlConnectionManager.class);
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final ControlMessageHandler handler;
    private final BootStrapContext context;
    private final CoordinationProtos.DrillbitEndpoint localIdentity;

    public ControlConnectionManager(CoordinationProtos.DrillbitEndpoint remoteEndpoint, CoordinationProtos.DrillbitEndpoint localIdentity, ControlMessageHandler handler, BootStrapContext context) {
        super(BitControl.BitControlHandshake.newBuilder().setRpcVersion(ControlRpcConfig.RPC_VERSION).setEndpoint(localIdentity).build(), remoteEndpoint.getAddress(), remoteEndpoint.getControlPort());
        assert (remoteEndpoint != null) : "Endpoint cannot be null.";
        assert (remoteEndpoint.getAddress() != null && !remoteEndpoint.getAddress().isEmpty()) : "Endpoint address cannot be null.";
        assert (remoteEndpoint.getControlPort() > 0) : String.format("Bit Port must be set to a port between 1 and 65k.  Was set to %d.", remoteEndpoint.getControlPort());
        this.endpoint = remoteEndpoint;
        this.localIdentity = localIdentity;
        this.handler = handler;
        this.context = context;
    }

    @Override
    protected BasicClient<?, ControlConnection, BitControl.BitControlHandshake, ?> getNewClient() {
        return new ControlClient(this.endpoint, this.localIdentity, this.handler, this.context, new ReconnectingConnection.CloseHandlerCreator());
    }
}

