/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.UUID;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlConnection
extends RemoteConnection {
    static final Logger logger = LoggerFactory.getLogger(ControlConnection.class);
    private final RpcBus<BitControl.RpcType, ControlConnection> bus;
    private final BufferAllocator allocator;
    private volatile CoordinationProtos.DrillbitEndpoint endpoint;
    private volatile boolean active = false;
    private final UUID id;

    public ControlConnection(Channel channel, RpcBus<BitControl.RpcType, ControlConnection> bus, BufferAllocator allocator) {
        super(channel);
        this.bus = bus;
        this.id = UUID.randomUUID();
        this.allocator = allocator;
    }

    void setEndpoint(CoordinationProtos.DrillbitEndpoint endpoint) {
        assert (this.endpoint == null) : "Endpoint should only be set once (only in the case in incoming server requests).";
        this.endpoint = endpoint;
        this.active = true;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> outcomeListener, BitControl.RpcType rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.bus.send(outcomeListener, this, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void sendUnsafe(RpcOutcomeListener<RECEIVE> outcomeListener, BitControl.RpcType rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.bus.send(outcomeListener, this, rpcType, protobufBody, clazz, true, dataBodies);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlConnection other = (ControlConnection)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }
}

