/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlProtobufLengthDecoder;
import org.apache.drill.exec.rpc.control.ControlRpcConfig;
import org.apache.drill.exec.rpc.control.DefaultInstanceHandler;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClient
extends BasicClient<BitControl.RpcType, ControlConnection, BitControl.BitControlHandshake, BitControl.BitControlHandshake> {
    static final Logger logger = LoggerFactory.getLogger(ControlClient.class);
    private final ControlMessageHandler handler;
    private final CoordinationProtos.DrillbitEndpoint remoteEndpoint;
    private volatile ControlConnection connection;
    private final ReconnectingConnection.CloseHandlerCreator closeHandlerFactory;
    private final CoordinationProtos.DrillbitEndpoint localIdentity;
    private final BufferAllocator allocator;

    public ControlClient(CoordinationProtos.DrillbitEndpoint remoteEndpoint, CoordinationProtos.DrillbitEndpoint localEndpoint, ControlMessageHandler handler, BootStrapContext context, ReconnectingConnection.CloseHandlerCreator closeHandlerFactory) {
        super(ControlRpcConfig.MAPPING, context.getAllocator().getUnderlyingAllocator(), context.getBitLoopGroup(), BitControl.RpcType.HANDSHAKE, BitControl.BitControlHandshake.class, BitControl.BitControlHandshake.PARSER);
        this.localIdentity = localEndpoint;
        this.remoteEndpoint = remoteEndpoint;
        this.handler = handler;
        this.closeHandlerFactory = closeHandlerFactory;
        this.allocator = context.getAllocator();
    }

    @Override
    public ControlConnection initRemoteConnection(Channel channel) {
        this.connection = new ControlConnection(channel, this, this.allocator);
        return this.connection;
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(ControlConnection clientConnection) {
        return this.closeHandlerFactory.getHandler(clientConnection, super.getCloseHandler(clientConnection));
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DefaultInstanceHandler.getResponseDefaultInstance(rpcType);
    }

    @Override
    protected Response handle(ControlConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        return this.handler.handle(connection, rpcType, pBody, dBody);
    }

    protected void validateHandshake(BitControl.BitControlHandshake handshake) throws RpcException {
        if (handshake.getRpcVersion() != ControlRpcConfig.RPC_VERSION) {
            throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", handshake.getRpcVersion(), ControlRpcConfig.RPC_VERSION));
        }
    }

    protected void finalizeConnection(BitControl.BitControlHandshake handshake, ControlConnection connection) {
        connection.setEndpoint(handshake.getEndpoint());
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new ControlProtobufLengthDecoder(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }
}

