/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Locale;
import org.apache.drill.exec.rpc.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportCheck {
    static final Logger logger = LoggerFactory.getLogger(TransportCheck.class);
    public static final boolean SUPPORTS_EPOLL;

    public static Class<? extends ServerSocketChannel> getServerSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static Class<? extends SocketChannel> getClientSocketChannel() {
        if (SUPPORTS_EPOLL) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static EventLoopGroup createEventLoopGroup(int nThreads, String prefix) {
        if (SUPPORTS_EPOLL) {
            return new EpollEventLoopGroup(nThreads, new NamedThreadFactory(prefix));
        }
        return new NioEventLoopGroup(nThreads, new NamedThreadFactory(prefix));
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.US).trim();
        if (!name.startsWith("linux") || !SystemPropertyUtil.getBoolean("drill.exec.disable-linux-epoll", false)) {
            // empty if block
        }
        SUPPORTS_EPOLL = false;
    }
}

