/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcExceptionHandler
implements ChannelHandler {
    static final Logger logger = LoggerFactory.getLogger(RpcExceptionHandler.class);

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!ctx.channel().isOpen() || cause.getMessage().equals("Connection reset by peer")) {
            logger.warn("Exception with closed channel", cause);
            return;
        }
        logger.error("Exception in pipeline.  Closing channel between local " + ctx.channel().localAddress() + " and remote " + ctx.channel().remoteAddress(), cause);
        ctx.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }
}

