/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcConfig {
    static final Logger logger = LoggerFactory.getLogger(RpcConfig.class);
    private final String name;
    private final Map<Internal.EnumLite, RpcMessageType<?, ?, ?>> sendMap;
    private final Map<Integer, RpcMessageType<?, ?, ?>> receiveMap;

    private RpcConfig(String name, Map<Internal.EnumLite, RpcMessageType<?, ?, ?>> sendMap, Map<Integer, RpcMessageType<?, ?, ?>> receiveMap) {
        this.name = name;
        this.sendMap = ImmutableMap.copyOf(sendMap);
        this.receiveMap = ImmutableMap.copyOf(receiveMap);
    }

    public String getName() {
        return this.name;
    }

    public boolean checkReceive(int rpcType, Class<?> receiveClass) {
        RpcMessageType<?, ?, ?> type = this.receiveMap.get(rpcType);
        if (type == null) {
            throw new IllegalStateException(String.format("%s: There is no defined RpcMessage type for a Rpc receive type number of %s.", this.name, rpcType));
        }
        if (receiveClass != type.getRet()) {
            throw new IllegalStateException(String.format("%s: The definition for receive doesn't match implementation code.  The definition is %s however the current receive for this type was of type %s.", this.name, type, receiveClass.getCanonicalName()));
        }
        return true;
    }

    public boolean checkSend(Internal.EnumLite send, Class<?> sendClass, Class<?> receiveClass) {
        RpcMessageType<?, ?, ?> type = this.sendMap.get(send);
        if (type == null) {
            throw new IllegalStateException(String.format("%s: There is no defined RpcMessage type for a Rpc send type of %s.", this.name, send));
        }
        if (type.getSend() != sendClass) {
            throw new IllegalStateException(String.format("%s: The definition for send doesn't match implementation code.  The definition is %s however the current send is trying to send an object of type %s.", this.name, type, sendClass.getCanonicalName()));
        }
        if (type.getRet() != receiveClass) {
            throw new IllegalStateException(String.format("%s: The definition for send doesn't match implementation code.  The definition is %s however the current send is trying to setup an expected reception of an object of type %s.", this.name, type, receiveClass.getCanonicalName()));
        }
        return true;
    }

    public boolean checkResponseSend(Internal.EnumLite responseType, Class<?> responseClass) {
        RpcMessageType<?, ?, ?> type = this.receiveMap.get(responseType.getNumber());
        if (type == null) {
            throw new IllegalStateException(String.format("%s: There is no defined RpcMessage type for a Rpc response of type %s.", this.name, responseType));
        }
        if (type.getRet() != responseClass) {
            throw new IllegalStateException(String.format("%s: The definition for the response doesn't match implementation code.  The definition is %s however the current response is trying to response with an object of type %s.", this.name, type, responseClass.getCanonicalName()));
        }
        return true;
    }

    public static RpcConfigBuilder newBuilder(String name) {
        return new RpcConfigBuilder(name);
    }

    public static class RpcConfigBuilder {
        private final String name;
        private Map<Internal.EnumLite, RpcMessageType<?, ?, ?>> sendMap = Maps.newHashMap();
        private Map<Integer, RpcMessageType<?, ?, ?>> receiveMap = Maps.newHashMap();

        private RpcConfigBuilder(String name) {
            this.name = name;
        }

        public <SEND extends MessageLite, RECEIVE extends MessageLite, T extends Internal.EnumLite> RpcConfigBuilder add(T sendEnum, Class<SEND> send, T receiveEnum, Class<RECEIVE> rec) {
            RpcMessageType<SEND, RECEIVE, T> type = new RpcMessageType<SEND, RECEIVE, T>(sendEnum, send, receiveEnum, rec);
            this.sendMap.put(sendEnum, type);
            this.receiveMap.put(receiveEnum.getNumber(), type);
            return this;
        }

        public RpcConfig build() {
            return new RpcConfig(this.name, this.sendMap, this.receiveMap);
        }
    }

    public static class RpcMessageType<SEND extends MessageLite, RECEIVE extends MessageLite, T extends Internal.EnumLite> {
        private Internal.EnumLite sendEnum;
        private Class<SEND> send;
        private Internal.EnumLite receiveEnum;
        private Class<RECEIVE> ret;

        public RpcMessageType(T sendEnum, Class<SEND> send, T receiveEnum, Class<RECEIVE> ret) {
            this.sendEnum = sendEnum;
            this.send = send;
            this.receiveEnum = receiveEnum;
            this.ret = ret;
        }

        public Class<SEND> getSend() {
            return this.send;
        }

        public Class<RECEIVE> getRet() {
            return this.ret;
        }

        public String toString() {
            return "RpcMessageType [sendEnum=" + this.sendEnum + ", send=" + this.send + ", receiveEnum=" + this.receiveEnum + ", ret=" + this.ret + "]";
        }
    }
}

