/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.ExecutionException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.rpc.ResettableBarrier;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteConnection
implements AutoCloseable,
ConnectionThrottle {
    static final Logger logger = LoggerFactory.getLogger(RemoteConnection.class);
    private final Channel channel;
    private final WriteManager writeManager;

    public boolean inEventLoop() {
        return this.channel.eventLoop().inEventLoop();
    }

    public RemoteConnection(Channel channel) {
        this.channel = channel;
        this.writeManager = new WriteManager();
        channel.pipeline().addLast(new BackPressureHandler());
    }

    public abstract BufferAllocator getAllocator();

    public final Channel getChannel() {
        return this.channel;
    }

    public boolean blockOnNotWritable(RpcOutcomeListener<?> listener) {
        try {
            this.writeManager.waitForWritable();
            return true;
        }
        catch (InterruptedException e) {
            listener.failed(new RpcException(e));
            return false;
        }
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.channel.config().setAutoRead(enableAutoRead);
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    @Override
    public void close() {
        try {
            this.channel.close().get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Caught exception while closing channel.", e);
        }
    }

    private class BackPressureHandler
    extends ChannelInboundHandlerAdapter {
        private BackPressureHandler() {
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            RemoteConnection.this.writeManager.setWritable(ctx.channel().isWritable());
            ctx.fireChannelWritabilityChanged();
        }
    }

    private static class WriteManager {
        private final ResettableBarrier barrier = new ResettableBarrier();

        public WriteManager() {
            this.barrier.openBarrier();
        }

        public void waitForWritable() throws InterruptedException {
            this.barrier.await();
        }

        public void setWritable(boolean isWritable) {
            if (isWritable) {
                this.barrier.openBarrier();
            } else {
                this.barrier.closeBarrier();
            }
        }
    }
}

