/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    static final Logger logger = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;

    public NamedThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.prefix + this.nextId.incrementAndGet());
        try {
            if (t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 10) {
                t.setPriority(10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }
}

