/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RpcCommand;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListeningCommand<T extends MessageLite, C extends RemoteConnection>
implements RpcCommand<T, C> {
    static final Logger logger = LoggerFactory.getLogger(ListeningCommand.class);
    private final RpcOutcomeListener<T> listener;

    public ListeningCommand(RpcOutcomeListener<T> listener) {
        this.listener = listener;
    }

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(RemoteConnection connection) {
        this.doRpcCall(new DeferredRpcOutcome(), connection);
    }

    @Override
    public void connectionSucceeded(RemoteConnection connection) {
        this.connectionAvailable(connection);
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
        this.listener.failed(RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t));
    }

    private class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            ListeningCommand.this.listener.failed(ex);
        }

        @Override
        public void success(T value, ByteBuf buf) {
            ListeningCommand.this.listener.success(value, buf);
        }
    }
}

