/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractFuture;
import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillRpcFutureImpl<V>
extends AbstractCheckedFuture<V, RpcException>
implements DrillRpcFuture<V>,
RpcOutcomeListener<V> {
    static final Logger logger = LoggerFactory.getLogger(DrillRpcFutureImpl.class);
    private volatile ByteBuf buffer;

    public DrillRpcFutureImpl() {
        super(new InnerFuture());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Drill doesn't currently support rpc cancellations. See javadocs for more detail.");
    }

    @Override
    protected RpcException mapException(Exception ex) {
        return RpcException.mapException(ex);
    }

    @Override
    public void failed(RpcException ex) {
        ((InnerFuture)this.delegate()).setException(ex);
    }

    @Override
    public void success(V value, ByteBuf buffer) {
        this.buffer = buffer;
        ((InnerFuture)this.delegate()).setValue(value);
    }

    private static class InnerFuture<T>
    extends AbstractFuture<T> {
        private InnerFuture() {
        }

        void setValue(Object value) {
            super.set(value);
        }

        @Override
        protected boolean setException(Throwable t) {
            return super.setException(t);
        }
    }
}

