/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.ChannelClosedException;
import org.apache.drill.exec.rpc.ChannelListenerWithCoordinationId;
import org.apache.drill.exec.rpc.PositiveAtomicInteger;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RemoteRpcException;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcome;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinationQueue {
    static final Logger logger = LoggerFactory.getLogger(CoordinationQueue.class);
    private final PositiveAtomicInteger circularInt = new PositiveAtomicInteger();
    private final Map<Integer, RpcOutcome<?>> map;

    public CoordinationQueue(int segmentSize, int segmentCount) {
        this.map = new ConcurrentHashMap(segmentSize, 0.75f, segmentCount);
    }

    void channelClosed(Throwable ex) {
        if (ex != null) {
            RpcException e = ex instanceof RpcException ? (RpcException)ex : new RpcException(ex);
            for (RpcOutcome<?> f : this.map.values()) {
                f.setException(e);
            }
        }
    }

    public <V> ChannelListenerWithCoordinationId get(RpcOutcomeListener<V> handler, Class<V> clazz, RemoteConnection connection) {
        int i = this.circularInt.getNext();
        RpcListener<V> future = new RpcListener<V>(handler, clazz, i, connection);
        RpcListener<V> old = this.map.put(i, future);
        if (old != null) {
            throw new IllegalStateException("You attempted to reuse a coordination id when the previous coordination id has not been removed.  This is likely rpc future callback memory leak.");
        }
        return future;
    }

    private RpcOutcome<?> removeFromMap(int coordinationId) {
        RpcOutcome<?> rpc = this.map.remove(coordinationId);
        if (rpc == null) {
            throw new IllegalStateException("Attempting to retrieve an rpc that wasn't first stored in the rpc coordination queue.  This would most likely happen if you're opposite endpoint sent multiple messages on the same coordination id.");
        }
        return rpc;
    }

    public <V> RpcOutcome<V> getFuture(int rpcType, int coordinationId, Class<V> clazz) {
        RpcOutcome<?> rpc = this.removeFromMap(coordinationId);
        Class<?> outcomeClass = rpc.getOutcomeType();
        if (outcomeClass != clazz) {
            throw new IllegalStateException(String.format("RPC Engine had a submission and response configuration mismatch.  The RPC request that you submitted was defined with an expected response type of %s.  However, when the response returned, a call to getResponseDefaultInstance() with Rpc number %d provided an expected class of %s.  This means either your submission uses the wrong type definitionor your getResponseDefaultInstance() method responds the wrong instance type ", clazz.getCanonicalName(), rpcType, outcomeClass.getCanonicalName()));
        }
        RpcOutcome<?> crpc = rpc;
        return crpc;
    }

    public void updateFailedFuture(int coordinationId, UserBitShared.DrillPBError failure) {
        try {
            RpcOutcome<?> rpc = this.removeFromMap(coordinationId);
            rpc.setException(new RemoteRpcException(failure));
        }
        catch (Exception ex) {
            logger.warn("Failed to remove from map.  Not a problem since we were updating on failed future.", ex);
        }
    }

    private class RpcListener<T>
    implements ChannelListenerWithCoordinationId,
    RpcOutcome<T> {
        final RpcOutcomeListener<T> handler;
        final Class<T> clazz;
        final int coordinationId;
        final RemoteConnection connection;

        public RpcListener(RpcOutcomeListener<T> handler, Class<T> clazz, int coordinationId, RemoteConnection connection) {
            this.handler = handler;
            this.clazz = clazz;
            this.coordinationId = coordinationId;
            this.connection = connection;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                CoordinationQueue.this.removeFromMap(this.coordinationId);
                if (future.channel().isActive()) {
                    throw new RpcException("Future failed");
                }
                throw new ChannelClosedException();
            }
        }

        @Override
        public void set(Object value, ByteBuf buffer) {
            assert (this.clazz.isAssignableFrom(value.getClass()));
            this.handler.success(value, buffer);
        }

        @Override
        public void setException(Throwable t) {
            this.handler.failed(RpcException.mapException(t));
        }

        @Override
        public Class<T> getOutcomeType() {
            return this.clazz;
        }

        @Override
        public int getCoordinationId() {
            return this.coordinationId;
        }
    }
}

