/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableBatch {
    static final Logger logger = LoggerFactory.getLogger(WritableBatch.class);
    private final UserBitShared.RecordBatchDef def;
    private final DrillBuf[] buffers;
    private boolean cleared = false;

    private WritableBatch(UserBitShared.RecordBatchDef def, List<DrillBuf> buffers) {
        this.def = def;
        this.buffers = buffers.toArray(new DrillBuf[buffers.size()]);
    }

    public UserBitShared.RecordBatchDef getDef() {
        return this.def;
    }

    public DrillBuf[] getBuffers() {
        return this.buffers;
    }

    public static WritableBatch getBatchNoHVWrap(int recordCount, Iterable<VectorWrapper<?>> vws, boolean isSV2) {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        for (VectorWrapper<?> vw : vws) {
            Preconditions.checkArgument(!vw.isHyper());
            vectors.add(vw.getValueVector());
        }
        return WritableBatch.getBatchNoHV(recordCount, vectors, isSV2);
    }

    public static WritableBatch getBatchNoHV(int recordCount, Iterable<ValueVector> vectors, boolean isSV2) {
        ArrayList<DrillBuf> buffers = Lists.newArrayList();
        ArrayList<UserBitShared.SerializedField> metadata = Lists.newArrayList();
        for (ValueVector vv : vectors) {
            metadata.add(vv.getMetadata());
            if (recordCount == 0) {
                vv.clear();
                continue;
            }
            for (DrillBuf b : vv.getBuffers(true)) {
                buffers.add(b);
            }
            vv.clear();
        }
        UserBitShared.RecordBatchDef batchDef = UserBitShared.RecordBatchDef.newBuilder().addAllField(metadata).setRecordCount(recordCount).setCarriesTwoByteSelectionVector(isSV2).build();
        WritableBatch b = new WritableBatch(batchDef, buffers);
        return b;
    }

    public static WritableBatch get(RecordBatch batch) {
        if (batch.getSchema() != null && batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            throw new UnsupportedOperationException("Only batches without hyper selections vectors are writable.");
        }
        boolean sv2 = batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(batch.getRecordCount(), batch, sv2);
    }

    public void retainBuffers(int increment) {
        for (DrillBuf buf : this.buffers) {
            buf.retain(increment);
        }
    }
}

