/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVectorWrapper<T extends ValueVector>
implements VectorWrapper<T> {
    static final Logger logger = LoggerFactory.getLogger(SimpleVectorWrapper.class);
    private ValueVector v;

    public SimpleVectorWrapper(ValueVector v) {
        this.v = v;
    }

    @Override
    public Class<T> getVectorClass() {
        return this.v.getClass();
    }

    @Override
    public MaterializedField getField() {
        return this.v.getField();
    }

    @Override
    public ValueVector getValueVector() {
        return this.v;
    }

    @Override
    public ValueVector[] getValueVectors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHyper() {
        return false;
    }

    @Override
    public void clear() {
        this.v.clear();
    }

    public static <T extends ValueVector> SimpleVectorWrapper<T> create(T v) {
        return new SimpleVectorWrapper<T>(v);
    }

    @Override
    public VectorWrapper<?> getChildWrapper(int[] ids) {
        if (ids.length == 1) {
            return this;
        }
        ValueVector vector = this.v;
        for (int i = 1; i < ids.length; ++i) {
            MapVector map = (MapVector)vector;
            vector = map.getVectorById(ids[i]);
        }
        return new SimpleVectorWrapper<T>(vector);
    }

    @Override
    public TypedFieldId getFieldIdIfMatches(int id, SchemaPath expectedPath) {
        if (!expectedPath.getRootSegment().segmentEquals(this.v.getField().getPath().getRootSegment())) {
            return null;
        }
        PathSegment.NameSegment seg = expectedPath.getRootSegment();
        if (this.v instanceof AbstractContainerVector) {
            AbstractContainerVector c = (AbstractContainerVector)this.v;
            TypedFieldId.Builder builder = TypedFieldId.newBuilder();
            builder.intermediateType(this.v.getField().getType());
            builder.addId(id);
            return c.getFieldIdIfMatches(builder, true, expectedPath.getRootSegment().getChild());
        }
        TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        builder.intermediateType(this.v.getField().getType());
        builder.addId(id);
        builder.finalType(this.v.getField().getType());
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isArray() && child.isLastPath()) {
            builder.remainder(child);
            builder.withIndex();
            builder.finalType(this.v.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
            return builder.build();
        }
        return null;
    }
}

