/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.netty.buffer.DrillBuf;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.SchemaBuilder;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBatchLoader
implements Iterable<VectorWrapper<?>>,
VectorAccessible {
    static final Logger logger = LoggerFactory.getLogger(RecordBatchLoader.class);
    private VectorContainer container = new VectorContainer();
    private final BufferAllocator allocator;
    private int valueCount;
    private BatchSchema schema;

    public RecordBatchLoader(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public boolean load(UserBitShared.RecordBatchDef def, DrillBuf buf) throws SchemaChangeException {
        this.container.zeroVectors();
        this.valueCount = def.getRecordCount();
        boolean schemaChanged = this.schema == null;
        HashMap<MaterializedField, ValueVector> oldFields = Maps.newHashMap();
        for (VectorWrapper<?> w : this.container) {
            ValueVector v = w.getValueVector();
            oldFields.put(v.getField(), v);
        }
        VectorContainer newVectors = new VectorContainer();
        List<UserBitShared.SerializedField> fields = def.getFieldList();
        int bufOffset = 0;
        for (UserBitShared.SerializedField fmd : fields) {
            MaterializedField fieldDef = MaterializedField.create(fmd);
            ValueVector vector = (ValueVector)oldFields.remove(fieldDef);
            if (vector == null) {
                schemaChanged = true;
                vector = TypeHelper.getNewVector(fieldDef, this.allocator);
            } else if (!vector.getField().getType().equals(fieldDef.getType())) {
                vector.clear();
                schemaChanged = true;
                vector = TypeHelper.getNewVector(fieldDef, this.allocator);
            }
            if (!(fmd.getValueCount() != 0 || fmd.hasGroupCount() && fmd.getGroupCount() != 0)) {
                AllocationHelper.allocate(vector, 0, 0, 0);
            } else {
                vector.load(fmd, buf.slice(bufOffset, fmd.getBufferLength()));
            }
            bufOffset += fmd.getBufferLength();
            newVectors.add(vector);
        }
        Preconditions.checkArgument(buf == null || bufOffset == buf.capacity());
        if (!oldFields.isEmpty()) {
            schemaChanged = true;
            for (ValueVector v : oldFields.values()) {
                v.close();
            }
        }
        SchemaBuilder b = BatchSchema.newBuilder();
        for (VectorWrapper<?> v : newVectors) {
            b.addField(v.getField());
        }
        b.setSelectionVectorMode(BatchSchema.SelectionVectorMode.NONE);
        this.schema = b.build();
        newVectors.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container = newVectors;
        return schemaChanged;
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public int getRecordCount() {
        return this.valueCount;
    }

    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    public WritableBatch getWritableBatch() {
        boolean isSV2 = this.schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE;
        return WritableBatch.getBatchNoHVWrap(this.valueCount, this.container, isSV2);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    public void clear() {
        this.container.clear();
    }

    public void canonicalize() {
        this.container = VectorContainer.canonicalize(this.container);
        SchemaBuilder b = BatchSchema.newBuilder();
        for (VectorWrapper<?> v : this.container) {
            b.addField(v.getField());
        }
        b.setSelectionVectorMode(BatchSchema.SelectionVectorMode.NONE);
        this.schema = b.build();
    }
}

