/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.UserBitShared;

public class MaterializedField {
    private Key key;
    private Set<MaterializedField> children = Sets.newLinkedHashSet();

    private MaterializedField(SchemaPath path, TypeProtos.MajorType type) {
        this.key = new Key(path, type);
    }

    public static MaterializedField create(UserBitShared.SerializedField serField) {
        MaterializedField field = new MaterializedField(SchemaPath.create(serField.getNamePart()), serField.getMajorType());
        for (UserBitShared.SerializedField sf : serField.getChildList()) {
            field.addChild(MaterializedField.create(sf));
        }
        return field;
    }

    public UserBitShared.SerializedField.Builder getAsBuilder() {
        return UserBitShared.SerializedField.newBuilder().setMajorType(this.key.type).setNamePart(this.key.path.getAsNamePart());
    }

    public void addChild(MaterializedField field) {
        this.children.add(field);
    }

    public String getLastName() {
        PathSegment seg = this.key.path.getRootSegment();
        while (seg.getChild() != null) {
            seg = seg.getChild();
        }
        return ((PathSegment)seg).getNameSegment().getPath();
    }

    public boolean matches(UserBitShared.SerializedField field) {
        MaterializedField f = MaterializedField.create(field);
        return f.equals(this);
    }

    public static MaterializedField create(String path, TypeProtos.MajorType type) {
        SchemaPath p = SchemaPath.getSimplePath(path);
        return MaterializedField.create(p, type);
    }

    public static MaterializedField create(SchemaPath path, TypeProtos.MajorType type) {
        return new MaterializedField(path, type);
    }

    public SchemaPath getPath() {
        return this.key.path;
    }

    @Deprecated
    public SchemaPath getAsSchemaPath() {
        return this.getPath();
    }

    public TypeProtos.MajorType getType() {
        return this.key.type;
    }

    public int getScale() {
        return this.key.type.getScale();
    }

    public int getPrecision() {
        return this.key.type.getPrecision();
    }

    public TypeProtos.DataMode getDataMode() {
        return this.key.type.getMode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedField other = (MaterializedField)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        int maxLen = 10;
        String childStr = this.children != null && !this.children.isEmpty() ? this.toString(this.children, 10) : "";
        return this.key.path + "(" + this.key.type.getMinorType().name() + ":" + this.key.type.getMode().name() + ")" + childStr;
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public class Key {
        private SchemaPath path;
        private TypeProtos.MajorType type;

        private Key(SchemaPath path, TypeProtos.MajorType type) {
            this.path = path;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }
}

