/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import java.util.Iterator;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;

public abstract class AbstractRecordBatch<T extends PhysicalOperator>
implements RecordBatch {
    protected final VectorContainer container;
    protected final PhysicalOperator popConfig;
    protected final FragmentContext context;
    protected final OperatorContext oContext;
    protected final OperatorStats stats;
    protected BatchState state;

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    public final RecordBatch.IterOutcome next(RecordBatch b) {
        return this.next(0, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RecordBatch.IterOutcome next(int inputIndex, RecordBatch b) {
        RecordBatch.IterOutcome next = null;
        this.stats.stopProcessing();
        try {
            if (this.context.isCancelled()) {
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.STOP;
                return iterOutcome;
            }
            next = b.next();
        }
        finally {
            this.stats.startProcessing();
        }
        switch (next) {
            case OK_NEW_SCHEMA: {
                this.stats.batchReceived(inputIndex, b.getRecordCount(), true);
                break;
            }
            case OK: {
                this.stats.batchReceived(inputIndex, b.getRecordCount(), false);
            }
        }
        return next;
    }

    @Override
    public final RecordBatch.IterOutcome next() {
        try {
            this.stats.startProcessing();
            switch (this.state) {
                case BUILD_SCHEMA: {
                    this.buildSchema();
                    if (this.state == BatchState.DONE) {
                        RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.NONE;
                        return iterOutcome;
                    }
                    this.state = BatchState.FIRST;
                    RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    return iterOutcome;
                }
                case DONE: {
                    RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.NONE;
                    return iterOutcome;
                }
            }
            RecordBatch.IterOutcome iterOutcome = this.innerNext();
            return iterOutcome;
        }
        catch (SchemaChangeException e) {
            throw new DrillRuntimeException(e);
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    public abstract RecordBatch.IterOutcome innerNext();

    @Override
    public BatchSchema getSchema() {
        return this.container.getSchema();
    }

    protected void buildSchema() throws SchemaChangeException {
    }

    @Override
    public void kill(boolean sendUpstream) {
        this.killIncoming(sendUpstream);
    }

    protected abstract void killIncoming(boolean var1);

    @Override
    public void cleanup() {
        this.container.clear();
        this.oContext.close();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public WritableBatch getWritableBatch() {
        WritableBatch batch = WritableBatch.get(this);
        return batch;
    }

    protected static enum BatchState {
        BUILD_SCHEMA,
        FIRST,
        NOT_FIRST,
        DONE;

    }
}

