/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.proto.helper;

import java.util.UUID;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;

public class QueryIdHelper {
    public static String getQueryId(UserBitShared.QueryId queryId) {
        return new UUID(queryId.getPart1(), queryId.getPart2()).toString();
    }

    public static UserBitShared.QueryId getQueryIdFromString(String queryId) {
        UUID uuid = UUID.fromString(queryId);
        return UserBitShared.QueryId.newBuilder().setPart1(uuid.getMostSignificantBits()).setPart2(uuid.getLeastSignificantBits()).build();
    }

    public static String getQueryIdentifier(ExecProtos.FragmentHandle h) {
        return QueryIdHelper.getQueryId(h.getQueryId()) + ":" + h.getMajorFragmentId() + ":" + h.getMinorFragmentId();
    }
}

