/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.proto;

import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import java.io.IOException;
import java.util.HashMap;
import org.apache.drill.common.types.SchemaTypeProtos;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.SchemaCoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;

public final class SchemaUserBitShared {

    public static final class MetricValue {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "metricId";
                }
                case 2: {
                    return "longValue";
                }
                case 3: {
                    return "doubleValue";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("metricId", 1);
            fieldMap.put("longValue", 2);
            fieldMap.put("doubleValue", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.MetricValue.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.MetricValue.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setMetricId(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.setLongValue(input.readInt64());
                            break;
                        }
                        case 3: {
                            builder.setDoubleValue(input.readDouble());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.MetricValue.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.MetricValue.Builder newMessage() {
                return UserBitShared.MetricValue.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return MetricValue.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return MetricValue.getFieldNumber(name);
            }

            public Class<UserBitShared.MetricValue.Builder> typeClass() {
                return UserBitShared.MetricValue.Builder.class;
            }

            public String messageName() {
                return UserBitShared.MetricValue.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.MetricValue.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.MetricValue.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.MetricValue> {
            @Override
            public void writeTo(Output output, UserBitShared.MetricValue message) throws IOException {
                if (message.hasMetricId()) {
                    output.writeInt32(1, message.getMetricId(), false);
                }
                if (message.hasLongValue()) {
                    output.writeInt64(2, message.getLongValue(), false);
                }
                if (message.hasDoubleValue()) {
                    output.writeDouble(3, message.getDoubleValue(), false);
                }
            }

            public boolean isInitialized(UserBitShared.MetricValue message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return MetricValue.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return MetricValue.getFieldNumber(name);
            }

            public Class<UserBitShared.MetricValue> typeClass() {
                return UserBitShared.MetricValue.class;
            }

            public String messageName() {
                return UserBitShared.MetricValue.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.MetricValue.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.MetricValue message) throws IOException {
            }

            @Override
            public UserBitShared.MetricValue newMessage() {
                return null;
            }
        }
    }

    public static final class StreamProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "records";
                }
                case 2: {
                    return "batches";
                }
                case 3: {
                    return "schemas";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("records", 1);
            fieldMap.put("batches", 2);
            fieldMap.put("schemas", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.StreamProfile.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.StreamProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setRecords(input.readInt64());
                            break;
                        }
                        case 2: {
                            builder.setBatches(input.readInt64());
                            break;
                        }
                        case 3: {
                            builder.setSchemas(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.StreamProfile.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.StreamProfile.Builder newMessage() {
                return UserBitShared.StreamProfile.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return StreamProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return StreamProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.StreamProfile.Builder> typeClass() {
                return UserBitShared.StreamProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.StreamProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.StreamProfile.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.StreamProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.StreamProfile> {
            @Override
            public void writeTo(Output output, UserBitShared.StreamProfile message) throws IOException {
                if (message.hasRecords()) {
                    output.writeInt64(1, message.getRecords(), false);
                }
                if (message.hasBatches()) {
                    output.writeInt64(2, message.getBatches(), false);
                }
                if (message.hasSchemas()) {
                    output.writeInt64(3, message.getSchemas(), false);
                }
            }

            public boolean isInitialized(UserBitShared.StreamProfile message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return StreamProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return StreamProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.StreamProfile> typeClass() {
                return UserBitShared.StreamProfile.class;
            }

            public String messageName() {
                return UserBitShared.StreamProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.StreamProfile.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.StreamProfile message) throws IOException {
            }

            @Override
            public UserBitShared.StreamProfile newMessage() {
                return null;
            }
        }
    }

    public static final class OperatorProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "inputProfile";
                }
                case 3: {
                    return "operatorId";
                }
                case 4: {
                    return "operatorType";
                }
                case 5: {
                    return "setupNanos";
                }
                case 6: {
                    return "processNanos";
                }
                case 7: {
                    return "localMemoryAllocated";
                }
                case 8: {
                    return "metric";
                }
                case 9: {
                    return "waitNanos";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("inputProfile", 1);
            fieldMap.put("operatorId", 3);
            fieldMap.put("operatorType", 4);
            fieldMap.put("setupNanos", 5);
            fieldMap.put("processNanos", 6);
            fieldMap.put("localMemoryAllocated", 7);
            fieldMap.put("metric", 8);
            fieldMap.put("waitNanos", 9);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.OperatorProfile.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.OperatorProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.addInputProfile(input.mergeObject(UserBitShared.StreamProfile.newBuilder(), StreamProfile.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setOperatorId(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setOperatorType(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setSetupNanos(input.readInt64());
                            break;
                        }
                        case 6: {
                            builder.setProcessNanos(input.readInt64());
                            break;
                        }
                        case 7: {
                            builder.setLocalMemoryAllocated(input.readInt64());
                            break;
                        }
                        case 8: {
                            builder.addMetric(input.mergeObject(UserBitShared.MetricValue.newBuilder(), MetricValue.MERGE));
                            break;
                        }
                        case 9: {
                            builder.setWaitNanos(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.OperatorProfile.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.OperatorProfile.Builder newMessage() {
                return UserBitShared.OperatorProfile.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return OperatorProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return OperatorProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.OperatorProfile.Builder> typeClass() {
                return UserBitShared.OperatorProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.OperatorProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.OperatorProfile.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.OperatorProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.OperatorProfile> {
            @Override
            public void writeTo(Output output, UserBitShared.OperatorProfile message) throws IOException {
                for (UserBitShared.StreamProfile inputProfile : message.getInputProfileList()) {
                    output.writeObject(1, inputProfile, StreamProfile.WRITE, true);
                }
                if (message.hasOperatorId()) {
                    output.writeInt32(3, message.getOperatorId(), false);
                }
                if (message.hasOperatorType()) {
                    output.writeInt32(4, message.getOperatorType(), false);
                }
                if (message.hasSetupNanos()) {
                    output.writeInt64(5, message.getSetupNanos(), false);
                }
                if (message.hasProcessNanos()) {
                    output.writeInt64(6, message.getProcessNanos(), false);
                }
                if (message.hasLocalMemoryAllocated()) {
                    output.writeInt64(7, message.getLocalMemoryAllocated(), false);
                }
                for (UserBitShared.MetricValue metric : message.getMetricList()) {
                    output.writeObject(8, metric, MetricValue.WRITE, true);
                }
                if (message.hasWaitNanos()) {
                    output.writeInt64(9, message.getWaitNanos(), false);
                }
            }

            public boolean isInitialized(UserBitShared.OperatorProfile message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return OperatorProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return OperatorProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.OperatorProfile> typeClass() {
                return UserBitShared.OperatorProfile.class;
            }

            public String messageName() {
                return UserBitShared.OperatorProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.OperatorProfile.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.OperatorProfile message) throws IOException {
            }

            @Override
            public UserBitShared.OperatorProfile newMessage() {
                return null;
            }
        }
    }

    public static final class MinorFragmentProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "state";
                }
                case 2: {
                    return "error";
                }
                case 3: {
                    return "minorFragmentId";
                }
                case 4: {
                    return "operatorProfile";
                }
                case 5: {
                    return "startTime";
                }
                case 6: {
                    return "endTime";
                }
                case 7: {
                    return "memoryUsed";
                }
                case 8: {
                    return "maxMemoryUsed";
                }
                case 9: {
                    return "endpoint";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("state", 1);
            fieldMap.put("error", 2);
            fieldMap.put("minorFragmentId", 3);
            fieldMap.put("operatorProfile", 4);
            fieldMap.put("startTime", 5);
            fieldMap.put("endTime", 6);
            fieldMap.put("memoryUsed", 7);
            fieldMap.put("maxMemoryUsed", 8);
            fieldMap.put("endpoint", 9);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.MinorFragmentProfile.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.MinorFragmentProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setState(UserBitShared.FragmentState.valueOf(input.readEnum()));
                            break;
                        }
                        case 2: {
                            builder.setError(input.mergeObject(UserBitShared.DrillPBError.newBuilder(), DrillPBError.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setMinorFragmentId(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.addOperatorProfile(input.mergeObject(UserBitShared.OperatorProfile.newBuilder(), OperatorProfile.MERGE));
                            break;
                        }
                        case 5: {
                            builder.setStartTime(input.readInt64());
                            break;
                        }
                        case 6: {
                            builder.setEndTime(input.readInt64());
                            break;
                        }
                        case 7: {
                            builder.setMemoryUsed(input.readInt64());
                            break;
                        }
                        case 8: {
                            builder.setMaxMemoryUsed(input.readInt64());
                            break;
                        }
                        case 9: {
                            builder.setEndpoint(input.mergeObject(CoordinationProtos.DrillbitEndpoint.newBuilder(), SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.MinorFragmentProfile.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.MinorFragmentProfile.Builder newMessage() {
                return UserBitShared.MinorFragmentProfile.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return MinorFragmentProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return MinorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MinorFragmentProfile.Builder> typeClass() {
                return UserBitShared.MinorFragmentProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.MinorFragmentProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.MinorFragmentProfile.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.MinorFragmentProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.MinorFragmentProfile> {
            @Override
            public void writeTo(Output output, UserBitShared.MinorFragmentProfile message) throws IOException {
                if (message.hasState()) {
                    output.writeEnum(1, message.getState().getNumber(), false);
                }
                if (message.hasError()) {
                    output.writeObject(2, message.getError(), DrillPBError.WRITE, false);
                }
                if (message.hasMinorFragmentId()) {
                    output.writeInt32(3, message.getMinorFragmentId(), false);
                }
                for (UserBitShared.OperatorProfile operatorProfile : message.getOperatorProfileList()) {
                    output.writeObject(4, operatorProfile, OperatorProfile.WRITE, true);
                }
                if (message.hasStartTime()) {
                    output.writeInt64(5, message.getStartTime(), false);
                }
                if (message.hasEndTime()) {
                    output.writeInt64(6, message.getEndTime(), false);
                }
                if (message.hasMemoryUsed()) {
                    output.writeInt64(7, message.getMemoryUsed(), false);
                }
                if (message.hasMaxMemoryUsed()) {
                    output.writeInt64(8, message.getMaxMemoryUsed(), false);
                }
                if (message.hasEndpoint()) {
                    output.writeObject(9, message.getEndpoint(), SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.MinorFragmentProfile message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return MinorFragmentProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return MinorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MinorFragmentProfile> typeClass() {
                return UserBitShared.MinorFragmentProfile.class;
            }

            public String messageName() {
                return UserBitShared.MinorFragmentProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.MinorFragmentProfile.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.MinorFragmentProfile message) throws IOException {
            }

            @Override
            public UserBitShared.MinorFragmentProfile newMessage() {
                return null;
            }
        }
    }

    public static final class MajorFragmentProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "majorFragmentId";
                }
                case 2: {
                    return "minorFragmentProfile";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("majorFragmentId", 1);
            fieldMap.put("minorFragmentProfile", 2);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.MajorFragmentProfile.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.MajorFragmentProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setMajorFragmentId(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.addMinorFragmentProfile(input.mergeObject(UserBitShared.MinorFragmentProfile.newBuilder(), MinorFragmentProfile.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.MajorFragmentProfile.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.MajorFragmentProfile.Builder newMessage() {
                return UserBitShared.MajorFragmentProfile.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return MajorFragmentProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return MajorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MajorFragmentProfile.Builder> typeClass() {
                return UserBitShared.MajorFragmentProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.MajorFragmentProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.MajorFragmentProfile.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.MajorFragmentProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.MajorFragmentProfile> {
            @Override
            public void writeTo(Output output, UserBitShared.MajorFragmentProfile message) throws IOException {
                if (message.hasMajorFragmentId()) {
                    output.writeInt32(1, message.getMajorFragmentId(), false);
                }
                for (UserBitShared.MinorFragmentProfile minorFragmentProfile : message.getMinorFragmentProfileList()) {
                    output.writeObject(2, minorFragmentProfile, MinorFragmentProfile.WRITE, true);
                }
            }

            public boolean isInitialized(UserBitShared.MajorFragmentProfile message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return MajorFragmentProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return MajorFragmentProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.MajorFragmentProfile> typeClass() {
                return UserBitShared.MajorFragmentProfile.class;
            }

            public String messageName() {
                return UserBitShared.MajorFragmentProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.MajorFragmentProfile.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.MajorFragmentProfile message) throws IOException {
            }

            @Override
            public UserBitShared.MajorFragmentProfile newMessage() {
                return null;
            }
        }
    }

    public static final class QueryProfile {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "id";
                }
                case 2: {
                    return "type";
                }
                case 3: {
                    return "start";
                }
                case 4: {
                    return "end";
                }
                case 5: {
                    return "query";
                }
                case 6: {
                    return "plan";
                }
                case 7: {
                    return "foreman";
                }
                case 8: {
                    return "state";
                }
                case 9: {
                    return "totalFragments";
                }
                case 10: {
                    return "finishedFragments";
                }
                case 11: {
                    return "fragmentProfile";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("id", 1);
            fieldMap.put("type", 2);
            fieldMap.put("start", 3);
            fieldMap.put("end", 4);
            fieldMap.put("query", 5);
            fieldMap.put("plan", 6);
            fieldMap.put("foreman", 7);
            fieldMap.put("state", 8);
            fieldMap.put("totalFragments", 9);
            fieldMap.put("finishedFragments", 10);
            fieldMap.put("fragmentProfile", 11);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryProfile.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.QueryProfile.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setId(input.mergeObject(UserBitShared.QueryId.newBuilder(), QueryId.MERGE));
                            break;
                        }
                        case 2: {
                            builder.setType(UserBitShared.QueryType.valueOf(input.readEnum()));
                            break;
                        }
                        case 3: {
                            builder.setStart(input.readInt64());
                            break;
                        }
                        case 4: {
                            builder.setEnd(input.readInt64());
                            break;
                        }
                        case 5: {
                            builder.setQuery(input.readString());
                            break;
                        }
                        case 6: {
                            builder.setPlan(input.readString());
                            break;
                        }
                        case 7: {
                            builder.setForeman(input.mergeObject(CoordinationProtos.DrillbitEndpoint.newBuilder(), SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        case 8: {
                            builder.setState(UserBitShared.QueryResult.QueryState.valueOf(input.readEnum()));
                            break;
                        }
                        case 9: {
                            builder.setTotalFragments(input.readInt32());
                            break;
                        }
                        case 10: {
                            builder.setFinishedFragments(input.readInt32());
                            break;
                        }
                        case 11: {
                            builder.addFragmentProfile(input.mergeObject(UserBitShared.MajorFragmentProfile.newBuilder(), MajorFragmentProfile.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryProfile.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.QueryProfile.Builder newMessage() {
                return UserBitShared.QueryProfile.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return QueryProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryProfile.Builder> typeClass() {
                return UserBitShared.QueryProfile.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryProfile.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.QueryProfile.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryProfile> {
            @Override
            public void writeTo(Output output, UserBitShared.QueryProfile message) throws IOException {
                if (message.hasId()) {
                    output.writeObject(1, message.getId(), QueryId.WRITE, false);
                }
                if (message.hasType()) {
                    output.writeEnum(2, message.getType().getNumber(), false);
                }
                if (message.hasStart()) {
                    output.writeInt64(3, message.getStart(), false);
                }
                if (message.hasEnd()) {
                    output.writeInt64(4, message.getEnd(), false);
                }
                if (message.hasQuery()) {
                    output.writeString(5, message.getQuery(), false);
                }
                if (message.hasPlan()) {
                    output.writeString(6, message.getPlan(), false);
                }
                if (message.hasForeman()) {
                    output.writeObject(7, message.getForeman(), SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
                if (message.hasState()) {
                    output.writeEnum(8, message.getState().getNumber(), false);
                }
                if (message.hasTotalFragments()) {
                    output.writeInt32(9, message.getTotalFragments(), false);
                }
                if (message.hasFinishedFragments()) {
                    output.writeInt32(10, message.getFinishedFragments(), false);
                }
                for (UserBitShared.MajorFragmentProfile fragmentProfile : message.getFragmentProfileList()) {
                    output.writeObject(11, fragmentProfile, MajorFragmentProfile.WRITE, true);
                }
            }

            public boolean isInitialized(UserBitShared.QueryProfile message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return QueryProfile.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryProfile.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryProfile> typeClass() {
                return UserBitShared.QueryProfile.class;
            }

            public String messageName() {
                return UserBitShared.QueryProfile.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryProfile.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.QueryProfile message) throws IOException {
            }

            @Override
            public UserBitShared.QueryProfile newMessage() {
                return null;
            }
        }
    }

    public static final class QueryInfo {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "query";
                }
                case 2: {
                    return "start";
                }
                case 3: {
                    return "state";
                }
                case 4: {
                    return "user";
                }
                case 5: {
                    return "foreman";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("query", 1);
            fieldMap.put("start", 2);
            fieldMap.put("state", 3);
            fieldMap.put("user", 4);
            fieldMap.put("foreman", 5);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryInfo.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.QueryInfo.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setQuery(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setStart(input.readInt64());
                            break;
                        }
                        case 3: {
                            builder.setState(UserBitShared.QueryResult.QueryState.valueOf(input.readEnum()));
                            break;
                        }
                        case 4: {
                            builder.setUser(input.readString());
                            break;
                        }
                        case 5: {
                            builder.setForeman(input.mergeObject(CoordinationProtos.DrillbitEndpoint.newBuilder(), SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryInfo.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.QueryInfo.Builder newMessage() {
                return UserBitShared.QueryInfo.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return QueryInfo.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryInfo.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryInfo.Builder> typeClass() {
                return UserBitShared.QueryInfo.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryInfo.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryInfo.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.QueryInfo.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryInfo> {
            @Override
            public void writeTo(Output output, UserBitShared.QueryInfo message) throws IOException {
                if (message.hasQuery()) {
                    output.writeString(1, message.getQuery(), false);
                }
                if (message.hasStart()) {
                    output.writeInt64(2, message.getStart(), false);
                }
                if (message.hasState()) {
                    output.writeEnum(3, message.getState().getNumber(), false);
                }
                if (message.hasUser()) {
                    output.writeString(4, message.getUser(), false);
                }
                if (message.hasForeman()) {
                    output.writeObject(5, message.getForeman(), SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.QueryInfo message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return QueryInfo.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryInfo.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryInfo> typeClass() {
                return UserBitShared.QueryInfo.class;
            }

            public String messageName() {
                return UserBitShared.QueryInfo.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryInfo.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.QueryInfo message) throws IOException {
            }

            @Override
            public UserBitShared.QueryInfo newMessage() {
                return null;
            }
        }
    }

    public static final class QueryResult {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "queryState";
                }
                case 2: {
                    return "queryId";
                }
                case 3: {
                    return "isLastChunk";
                }
                case 4: {
                    return "rowCount";
                }
                case 5: {
                    return "recordsScan";
                }
                case 6: {
                    return "recordsError";
                }
                case 7: {
                    return "submissionTime";
                }
                case 8: {
                    return "nodeStatus";
                }
                case 9: {
                    return "error";
                }
                case 10: {
                    return "def";
                }
                case 11: {
                    return "schemaChanged";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("queryState", 1);
            fieldMap.put("queryId", 2);
            fieldMap.put("isLastChunk", 3);
            fieldMap.put("rowCount", 4);
            fieldMap.put("recordsScan", 5);
            fieldMap.put("recordsError", 6);
            fieldMap.put("submissionTime", 7);
            fieldMap.put("nodeStatus", 8);
            fieldMap.put("error", 9);
            fieldMap.put("def", 10);
            fieldMap.put("schemaChanged", 11);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryResult.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.QueryResult.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setQueryState(UserBitShared.QueryResult.QueryState.valueOf(input.readEnum()));
                            break;
                        }
                        case 2: {
                            builder.setQueryId(input.mergeObject(UserBitShared.QueryId.newBuilder(), QueryId.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setIsLastChunk(input.readBool());
                            break;
                        }
                        case 4: {
                            builder.setRowCount(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setRecordsScan(input.readInt64());
                            break;
                        }
                        case 6: {
                            builder.setRecordsError(input.readInt64());
                            break;
                        }
                        case 7: {
                            builder.setSubmissionTime(input.readInt64());
                            break;
                        }
                        case 8: {
                            builder.addNodeStatus(input.mergeObject(UserBitShared.NodeStatus.newBuilder(), NodeStatus.MERGE));
                            break;
                        }
                        case 9: {
                            builder.addError(input.mergeObject(UserBitShared.DrillPBError.newBuilder(), DrillPBError.MERGE));
                            break;
                        }
                        case 10: {
                            builder.setDef(input.mergeObject(UserBitShared.RecordBatchDef.newBuilder(), RecordBatchDef.MERGE));
                            break;
                        }
                        case 11: {
                            builder.setSchemaChanged(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryResult.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.QueryResult.Builder newMessage() {
                return UserBitShared.QueryResult.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return QueryResult.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryResult.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryResult.Builder> typeClass() {
                return UserBitShared.QueryResult.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryResult.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryResult.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.QueryResult.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryResult> {
            @Override
            public void writeTo(Output output, UserBitShared.QueryResult message) throws IOException {
                if (message.hasQueryState()) {
                    output.writeEnum(1, message.getQueryState().getNumber(), false);
                }
                if (message.hasQueryId()) {
                    output.writeObject(2, message.getQueryId(), QueryId.WRITE, false);
                }
                if (message.hasIsLastChunk()) {
                    output.writeBool(3, message.getIsLastChunk(), false);
                }
                if (message.hasRowCount()) {
                    output.writeInt32(4, message.getRowCount(), false);
                }
                if (message.hasRecordsScan()) {
                    output.writeInt64(5, message.getRecordsScan(), false);
                }
                if (message.hasRecordsError()) {
                    output.writeInt64(6, message.getRecordsError(), false);
                }
                if (message.hasSubmissionTime()) {
                    output.writeInt64(7, message.getSubmissionTime(), false);
                }
                for (UserBitShared.NodeStatus nodeStatus : message.getNodeStatusList()) {
                    output.writeObject(8, nodeStatus, NodeStatus.WRITE, true);
                }
                for (UserBitShared.DrillPBError error : message.getErrorList()) {
                    output.writeObject(9, error, DrillPBError.WRITE, true);
                }
                if (message.hasDef()) {
                    output.writeObject(10, message.getDef(), RecordBatchDef.WRITE, false);
                }
                if (message.hasSchemaChanged()) {
                    output.writeBool(11, message.getSchemaChanged(), false);
                }
            }

            public boolean isInitialized(UserBitShared.QueryResult message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return QueryResult.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryResult.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryResult> typeClass() {
                return UserBitShared.QueryResult.class;
            }

            public String messageName() {
                return UserBitShared.QueryResult.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryResult.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.QueryResult message) throws IOException {
            }

            @Override
            public UserBitShared.QueryResult newMessage() {
                return null;
            }
        }
    }

    public static final class NodeStatus {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "nodeId";
                }
                case 2: {
                    return "memoryFootprint";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("nodeId", 1);
            fieldMap.put("memoryFootprint", 2);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.NodeStatus.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.NodeStatus.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setNodeId(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.setMemoryFootprint(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.NodeStatus.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.NodeStatus.Builder newMessage() {
                return UserBitShared.NodeStatus.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return NodeStatus.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return NodeStatus.getFieldNumber(name);
            }

            public Class<UserBitShared.NodeStatus.Builder> typeClass() {
                return UserBitShared.NodeStatus.Builder.class;
            }

            public String messageName() {
                return UserBitShared.NodeStatus.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.NodeStatus.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.NodeStatus.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.NodeStatus> {
            @Override
            public void writeTo(Output output, UserBitShared.NodeStatus message) throws IOException {
                if (message.hasNodeId()) {
                    output.writeInt32(1, message.getNodeId(), false);
                }
                if (message.hasMemoryFootprint()) {
                    output.writeInt64(2, message.getMemoryFootprint(), false);
                }
            }

            public boolean isInitialized(UserBitShared.NodeStatus message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return NodeStatus.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return NodeStatus.getFieldNumber(name);
            }

            public Class<UserBitShared.NodeStatus> typeClass() {
                return UserBitShared.NodeStatus.class;
            }

            public String messageName() {
                return UserBitShared.NodeStatus.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.NodeStatus.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.NodeStatus message) throws IOException {
            }

            @Override
            public UserBitShared.NodeStatus newMessage() {
                return null;
            }
        }
    }

    public static final class SerializedField {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "majorType";
                }
                case 2: {
                    return "namePart";
                }
                case 3: {
                    return "child";
                }
                case 4: {
                    return "valueCount";
                }
                case 5: {
                    return "varByteLength";
                }
                case 6: {
                    return "groupCount";
                }
                case 7: {
                    return "bufferLength";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("majorType", 1);
            fieldMap.put("namePart", 2);
            fieldMap.put("child", 3);
            fieldMap.put("valueCount", 4);
            fieldMap.put("varByteLength", 5);
            fieldMap.put("groupCount", 6);
            fieldMap.put("bufferLength", 7);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.SerializedField.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.SerializedField.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setMajorType(input.mergeObject(TypeProtos.MajorType.newBuilder(), SchemaTypeProtos.MajorType.MERGE));
                            break;
                        }
                        case 2: {
                            builder.setNamePart(input.mergeObject(UserBitShared.NamePart.newBuilder(), NamePart.MERGE));
                            break;
                        }
                        case 3: {
                            builder.addChild(input.mergeObject(UserBitShared.SerializedField.newBuilder(), MERGE));
                            break;
                        }
                        case 4: {
                            builder.setValueCount(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setVarByteLength(input.readInt32());
                            break;
                        }
                        case 6: {
                            builder.setGroupCount(input.readInt32());
                            break;
                        }
                        case 7: {
                            builder.setBufferLength(input.readInt32());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.SerializedField.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.SerializedField.Builder newMessage() {
                return UserBitShared.SerializedField.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return SerializedField.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return SerializedField.getFieldNumber(name);
            }

            public Class<UserBitShared.SerializedField.Builder> typeClass() {
                return UserBitShared.SerializedField.Builder.class;
            }

            public String messageName() {
                return UserBitShared.SerializedField.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.SerializedField.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.SerializedField.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.SerializedField> {
            @Override
            public void writeTo(Output output, UserBitShared.SerializedField message) throws IOException {
                if (message.hasMajorType()) {
                    output.writeObject(1, message.getMajorType(), SchemaTypeProtos.MajorType.WRITE, false);
                }
                if (message.hasNamePart()) {
                    output.writeObject(2, message.getNamePart(), NamePart.WRITE, false);
                }
                for (UserBitShared.SerializedField child : message.getChildList()) {
                    output.writeObject(3, child, WRITE, true);
                }
                if (message.hasValueCount()) {
                    output.writeInt32(4, message.getValueCount(), false);
                }
                if (message.hasVarByteLength()) {
                    output.writeInt32(5, message.getVarByteLength(), false);
                }
                if (message.hasGroupCount()) {
                    output.writeInt32(6, message.getGroupCount(), false);
                }
                if (message.hasBufferLength()) {
                    output.writeInt32(7, message.getBufferLength(), false);
                }
            }

            public boolean isInitialized(UserBitShared.SerializedField message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return SerializedField.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return SerializedField.getFieldNumber(name);
            }

            public Class<UserBitShared.SerializedField> typeClass() {
                return UserBitShared.SerializedField.class;
            }

            public String messageName() {
                return UserBitShared.SerializedField.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.SerializedField.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.SerializedField message) throws IOException {
            }

            @Override
            public UserBitShared.SerializedField newMessage() {
                return null;
            }
        }
    }

    public static final class NamePart {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "type";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "child";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("type", 1);
            fieldMap.put("name", 2);
            fieldMap.put("child", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.NamePart.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.NamePart.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setType(UserBitShared.NamePart.Type.valueOf(input.readEnum()));
                            break;
                        }
                        case 2: {
                            builder.setName(input.readString());
                            break;
                        }
                        case 3: {
                            builder.setChild(input.mergeObject(UserBitShared.NamePart.newBuilder(), MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.NamePart.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.NamePart.Builder newMessage() {
                return UserBitShared.NamePart.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return NamePart.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return NamePart.getFieldNumber(name);
            }

            public Class<UserBitShared.NamePart.Builder> typeClass() {
                return UserBitShared.NamePart.Builder.class;
            }

            public String messageName() {
                return UserBitShared.NamePart.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.NamePart.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.NamePart.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.NamePart> {
            @Override
            public void writeTo(Output output, UserBitShared.NamePart message) throws IOException {
                if (message.hasType()) {
                    output.writeEnum(1, message.getType().getNumber(), false);
                }
                if (message.hasName()) {
                    output.writeString(2, message.getName(), false);
                }
                if (message.hasChild()) {
                    output.writeObject(3, message.getChild(), WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.NamePart message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return NamePart.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return NamePart.getFieldNumber(name);
            }

            public Class<UserBitShared.NamePart> typeClass() {
                return UserBitShared.NamePart.class;
            }

            public String messageName() {
                return UserBitShared.NamePart.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.NamePart.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.NamePart message) throws IOException {
            }

            @Override
            public UserBitShared.NamePart newMessage() {
                return null;
            }
        }
    }

    public static final class RecordBatchDef {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "recordCount";
                }
                case 2: {
                    return "field";
                }
                case 3: {
                    return "carriesTwoByteSelectionVector";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("recordCount", 1);
            fieldMap.put("field", 2);
            fieldMap.put("carriesTwoByteSelectionVector", 3);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.RecordBatchDef.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.RecordBatchDef.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setRecordCount(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.addField(input.mergeObject(UserBitShared.SerializedField.newBuilder(), SerializedField.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setCarriesTwoByteSelectionVector(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.RecordBatchDef.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.RecordBatchDef.Builder newMessage() {
                return UserBitShared.RecordBatchDef.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return RecordBatchDef.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return RecordBatchDef.getFieldNumber(name);
            }

            public Class<UserBitShared.RecordBatchDef.Builder> typeClass() {
                return UserBitShared.RecordBatchDef.Builder.class;
            }

            public String messageName() {
                return UserBitShared.RecordBatchDef.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.RecordBatchDef.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.RecordBatchDef.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.RecordBatchDef> {
            @Override
            public void writeTo(Output output, UserBitShared.RecordBatchDef message) throws IOException {
                if (message.hasRecordCount()) {
                    output.writeInt32(1, message.getRecordCount(), false);
                }
                for (UserBitShared.SerializedField field : message.getFieldList()) {
                    output.writeObject(2, field, SerializedField.WRITE, true);
                }
                if (message.hasCarriesTwoByteSelectionVector()) {
                    output.writeBool(3, message.getCarriesTwoByteSelectionVector(), false);
                }
            }

            public boolean isInitialized(UserBitShared.RecordBatchDef message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return RecordBatchDef.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return RecordBatchDef.getFieldNumber(name);
            }

            public Class<UserBitShared.RecordBatchDef> typeClass() {
                return UserBitShared.RecordBatchDef.class;
            }

            public String messageName() {
                return UserBitShared.RecordBatchDef.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.RecordBatchDef.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.RecordBatchDef message) throws IOException {
            }

            @Override
            public UserBitShared.RecordBatchDef newMessage() {
                return null;
            }
        }
    }

    public static final class ParsingError {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 2: {
                    return "startColumn";
                }
                case 3: {
                    return "startRow";
                }
                case 4: {
                    return "endColumn";
                }
                case 5: {
                    return "endRow";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("startColumn", 2);
            fieldMap.put("startRow", 3);
            fieldMap.put("endColumn", 4);
            fieldMap.put("endRow", 5);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.ParsingError.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.ParsingError.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 2: {
                            builder.setStartColumn(input.readInt32());
                            break;
                        }
                        case 3: {
                            builder.setStartRow(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setEndColumn(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setEndRow(input.readInt32());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.ParsingError.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.ParsingError.Builder newMessage() {
                return UserBitShared.ParsingError.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return ParsingError.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return ParsingError.getFieldNumber(name);
            }

            public Class<UserBitShared.ParsingError.Builder> typeClass() {
                return UserBitShared.ParsingError.Builder.class;
            }

            public String messageName() {
                return UserBitShared.ParsingError.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.ParsingError.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.ParsingError.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.ParsingError> {
            @Override
            public void writeTo(Output output, UserBitShared.ParsingError message) throws IOException {
                if (message.hasStartColumn()) {
                    output.writeInt32(2, message.getStartColumn(), false);
                }
                if (message.hasStartRow()) {
                    output.writeInt32(3, message.getStartRow(), false);
                }
                if (message.hasEndColumn()) {
                    output.writeInt32(4, message.getEndColumn(), false);
                }
                if (message.hasEndRow()) {
                    output.writeInt32(5, message.getEndRow(), false);
                }
            }

            public boolean isInitialized(UserBitShared.ParsingError message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return ParsingError.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return ParsingError.getFieldNumber(name);
            }

            public Class<UserBitShared.ParsingError> typeClass() {
                return UserBitShared.ParsingError.class;
            }

            public String messageName() {
                return UserBitShared.ParsingError.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.ParsingError.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.ParsingError message) throws IOException {
            }

            @Override
            public UserBitShared.ParsingError newMessage() {
                return null;
            }
        }
    }

    public static final class StackTraceElementWrapper {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "className";
                }
                case 2: {
                    return "fileName";
                }
                case 3: {
                    return "lineNumber";
                }
                case 4: {
                    return "methodName";
                }
                case 5: {
                    return "isNativeMethod";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("className", 1);
            fieldMap.put("fileName", 2);
            fieldMap.put("lineNumber", 3);
            fieldMap.put("methodName", 4);
            fieldMap.put("isNativeMethod", 5);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.StackTraceElementWrapper.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.StackTraceElementWrapper.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setClassName(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setFileName(input.readString());
                            break;
                        }
                        case 3: {
                            builder.setLineNumber(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setMethodName(input.readString());
                            break;
                        }
                        case 5: {
                            builder.setIsNativeMethod(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.StackTraceElementWrapper.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.StackTraceElementWrapper.Builder newMessage() {
                return UserBitShared.StackTraceElementWrapper.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return StackTraceElementWrapper.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return StackTraceElementWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.StackTraceElementWrapper.Builder> typeClass() {
                return UserBitShared.StackTraceElementWrapper.Builder.class;
            }

            public String messageName() {
                return UserBitShared.StackTraceElementWrapper.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.StackTraceElementWrapper.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.StackTraceElementWrapper.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.StackTraceElementWrapper> {
            @Override
            public void writeTo(Output output, UserBitShared.StackTraceElementWrapper message) throws IOException {
                if (message.hasClassName()) {
                    output.writeString(1, message.getClassName(), false);
                }
                if (message.hasFileName()) {
                    output.writeString(2, message.getFileName(), false);
                }
                if (message.hasLineNumber()) {
                    output.writeInt32(3, message.getLineNumber(), false);
                }
                if (message.hasMethodName()) {
                    output.writeString(4, message.getMethodName(), false);
                }
                if (message.hasIsNativeMethod()) {
                    output.writeBool(5, message.getIsNativeMethod(), false);
                }
            }

            public boolean isInitialized(UserBitShared.StackTraceElementWrapper message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return StackTraceElementWrapper.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return StackTraceElementWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.StackTraceElementWrapper> typeClass() {
                return UserBitShared.StackTraceElementWrapper.class;
            }

            public String messageName() {
                return UserBitShared.StackTraceElementWrapper.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.StackTraceElementWrapper.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.StackTraceElementWrapper message) throws IOException {
            }

            @Override
            public UserBitShared.StackTraceElementWrapper newMessage() {
                return null;
            }
        }
    }

    public static final class ExceptionWrapper {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "exceptionClass";
                }
                case 2: {
                    return "message";
                }
                case 3: {
                    return "stackTrace";
                }
                case 4: {
                    return "cause";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("exceptionClass", 1);
            fieldMap.put("message", 2);
            fieldMap.put("stackTrace", 3);
            fieldMap.put("cause", 4);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.ExceptionWrapper.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.ExceptionWrapper.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setExceptionClass(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setMessage(input.readString());
                            break;
                        }
                        case 3: {
                            builder.addStackTrace(input.mergeObject(UserBitShared.StackTraceElementWrapper.newBuilder(), StackTraceElementWrapper.MERGE));
                            break;
                        }
                        case 4: {
                            builder.setCause(input.mergeObject(UserBitShared.ExceptionWrapper.newBuilder(), MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.ExceptionWrapper.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.ExceptionWrapper.Builder newMessage() {
                return UserBitShared.ExceptionWrapper.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return ExceptionWrapper.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return ExceptionWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.ExceptionWrapper.Builder> typeClass() {
                return UserBitShared.ExceptionWrapper.Builder.class;
            }

            public String messageName() {
                return UserBitShared.ExceptionWrapper.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.ExceptionWrapper.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.ExceptionWrapper.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.ExceptionWrapper> {
            @Override
            public void writeTo(Output output, UserBitShared.ExceptionWrapper message) throws IOException {
                if (message.hasExceptionClass()) {
                    output.writeString(1, message.getExceptionClass(), false);
                }
                if (message.hasMessage()) {
                    output.writeString(2, message.getMessage(), false);
                }
                for (UserBitShared.StackTraceElementWrapper stackTrace : message.getStackTraceList()) {
                    output.writeObject(3, stackTrace, StackTraceElementWrapper.WRITE, true);
                }
                if (message.hasCause()) {
                    output.writeObject(4, message.getCause(), WRITE, false);
                }
            }

            public boolean isInitialized(UserBitShared.ExceptionWrapper message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return ExceptionWrapper.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return ExceptionWrapper.getFieldNumber(name);
            }

            public Class<UserBitShared.ExceptionWrapper> typeClass() {
                return UserBitShared.ExceptionWrapper.class;
            }

            public String messageName() {
                return UserBitShared.ExceptionWrapper.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.ExceptionWrapper.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.ExceptionWrapper message) throws IOException {
            }

            @Override
            public UserBitShared.ExceptionWrapper newMessage() {
                return null;
            }
        }
    }

    public static final class DrillPBError {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "errorId";
                }
                case 2: {
                    return "endpoint";
                }
                case 3: {
                    return "errorType";
                }
                case 4: {
                    return "message";
                }
                case 5: {
                    return "exception";
                }
                case 6: {
                    return "parsingError";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("errorId", 1);
            fieldMap.put("endpoint", 2);
            fieldMap.put("errorType", 3);
            fieldMap.put("message", 4);
            fieldMap.put("exception", 5);
            fieldMap.put("parsingError", 6);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.DrillPBError.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.DrillPBError.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setErrorId(input.readString());
                            break;
                        }
                        case 2: {
                            builder.setEndpoint(input.mergeObject(CoordinationProtos.DrillbitEndpoint.newBuilder(), SchemaCoordinationProtos.DrillbitEndpoint.MERGE));
                            break;
                        }
                        case 3: {
                            builder.setErrorType(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setMessage(input.readString());
                            break;
                        }
                        case 5: {
                            builder.setException(input.mergeObject(UserBitShared.ExceptionWrapper.newBuilder(), ExceptionWrapper.MERGE));
                            break;
                        }
                        case 6: {
                            builder.addParsingError(input.mergeObject(UserBitShared.ParsingError.newBuilder(), ParsingError.MERGE));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.DrillPBError.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.DrillPBError.Builder newMessage() {
                return UserBitShared.DrillPBError.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return DrillPBError.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return DrillPBError.getFieldNumber(name);
            }

            public Class<UserBitShared.DrillPBError.Builder> typeClass() {
                return UserBitShared.DrillPBError.Builder.class;
            }

            public String messageName() {
                return UserBitShared.DrillPBError.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.DrillPBError.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.DrillPBError.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.DrillPBError> {
            @Override
            public void writeTo(Output output, UserBitShared.DrillPBError message) throws IOException {
                if (message.hasErrorId()) {
                    output.writeString(1, message.getErrorId(), false);
                }
                if (message.hasEndpoint()) {
                    output.writeObject(2, message.getEndpoint(), SchemaCoordinationProtos.DrillbitEndpoint.WRITE, false);
                }
                if (message.hasErrorType()) {
                    output.writeInt32(3, message.getErrorType(), false);
                }
                if (message.hasMessage()) {
                    output.writeString(4, message.getMessage(), false);
                }
                if (message.hasException()) {
                    output.writeObject(5, message.getException(), ExceptionWrapper.WRITE, false);
                }
                for (UserBitShared.ParsingError parsingError : message.getParsingErrorList()) {
                    output.writeObject(6, parsingError, ParsingError.WRITE, true);
                }
            }

            public boolean isInitialized(UserBitShared.DrillPBError message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return DrillPBError.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return DrillPBError.getFieldNumber(name);
            }

            public Class<UserBitShared.DrillPBError> typeClass() {
                return UserBitShared.DrillPBError.class;
            }

            public String messageName() {
                return UserBitShared.DrillPBError.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.DrillPBError.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.DrillPBError message) throws IOException {
            }

            @Override
            public UserBitShared.DrillPBError newMessage() {
                return null;
            }
        }
    }

    public static final class QueryId {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "part1";
                }
                case 2: {
                    return "part2";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("part1", 1);
            fieldMap.put("part2", 2);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.QueryId.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.QueryId.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setPart1(input.readSFixed64());
                            break;
                        }
                        case 2: {
                            builder.setPart2(input.readSFixed64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.QueryId.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.QueryId.Builder newMessage() {
                return UserBitShared.QueryId.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return QueryId.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryId.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryId.Builder> typeClass() {
                return UserBitShared.QueryId.Builder.class;
            }

            public String messageName() {
                return UserBitShared.QueryId.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryId.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.QueryId.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.QueryId> {
            @Override
            public void writeTo(Output output, UserBitShared.QueryId message) throws IOException {
                if (message.hasPart1()) {
                    output.writeSFixed64(1, message.getPart1(), false);
                }
                if (message.hasPart2()) {
                    output.writeSFixed64(2, message.getPart2(), false);
                }
            }

            public boolean isInitialized(UserBitShared.QueryId message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return QueryId.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return QueryId.getFieldNumber(name);
            }

            public Class<UserBitShared.QueryId> typeClass() {
                return UserBitShared.QueryId.class;
            }

            public String messageName() {
                return UserBitShared.QueryId.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.QueryId.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.QueryId message) throws IOException {
            }

            @Override
            public UserBitShared.QueryId newMessage() {
                return null;
            }
        }
    }

    public static final class UserCredentials {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "userName";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("userName", 1);
        }

        public static class BuilderSchema
        implements Schema<UserBitShared.UserCredentials.Builder> {
            @Override
            public void mergeFrom(Input input, UserBitShared.UserCredentials.Builder builder) throws IOException {
                int number = input.readFieldNumber(this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setUserName(input.readString());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, this);
                        }
                    }
                    number = input.readFieldNumber(this);
                }
            }

            public boolean isInitialized(UserBitShared.UserCredentials.Builder builder) {
                return builder.isInitialized();
            }

            @Override
            public UserBitShared.UserCredentials.Builder newMessage() {
                return UserBitShared.UserCredentials.newBuilder();
            }

            @Override
            public String getFieldName(int number) {
                return UserCredentials.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return UserCredentials.getFieldNumber(name);
            }

            public Class<UserBitShared.UserCredentials.Builder> typeClass() {
                return UserBitShared.UserCredentials.Builder.class;
            }

            public String messageName() {
                return UserBitShared.UserCredentials.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.UserCredentials.class.getName();
            }

            @Override
            public void writeTo(Output output, UserBitShared.UserCredentials.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<UserBitShared.UserCredentials> {
            @Override
            public void writeTo(Output output, UserBitShared.UserCredentials message) throws IOException {
                if (message.hasUserName()) {
                    output.writeString(1, message.getUserName(), false);
                }
            }

            public boolean isInitialized(UserBitShared.UserCredentials message) {
                return message.isInitialized();
            }

            @Override
            public String getFieldName(int number) {
                return UserCredentials.getFieldName(number);
            }

            @Override
            public int getFieldNumber(String name) {
                return UserCredentials.getFieldNumber(name);
            }

            public Class<UserBitShared.UserCredentials> typeClass() {
                return UserBitShared.UserCredentials.class;
            }

            public String messageName() {
                return UserBitShared.UserCredentials.class.getSimpleName();
            }

            @Override
            public String messageFullName() {
                return UserBitShared.UserCredentials.class.getName();
            }

            @Override
            public void mergeFrom(Input input, UserBitShared.UserCredentials message) throws IOException {
            }

            @Override
            public UserBitShared.UserCredentials newMessage() {
                return null;
            }
        }
    }
}

