/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelDataTypeHolder {
    static final Logger logger = LoggerFactory.getLogger(RelDataTypeHolder.class);
    List<RelDataTypeField> fields = Lists.newArrayList();
    private RelDataTypeFactory typeFactory;

    public List<RelDataTypeField> getFieldList(RelDataTypeFactory typeFactory) {
        this.addStarIfEmpty(typeFactory);
        return this.fields;
    }

    public int getFieldCount() {
        this.addStarIfEmpty(this.typeFactory);
        return this.fields.size();
    }

    private void addStarIfEmpty(RelDataTypeFactory typeFactory) {
        if (this.fields.isEmpty()) {
            this.getField(typeFactory, "*");
        }
    }

    public RelDataTypeField getField(RelDataTypeFactory typeFactory, String fieldName) {
        for (RelDataTypeField f : this.fields) {
            if (!fieldName.equalsIgnoreCase(f.getName())) continue;
            return f;
        }
        RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, this.fields.size(), typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true));
        this.fields.add(newField);
        return newField;
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (RelDataTypeField f : this.fields) {
            fieldNames.add(f.getName());
        }
        return fieldNames;
    }

    public void setRelDataTypeFactory(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

