/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.reltype.RelDataTypePrecedenceList;
import org.eigenbase.sql.type.SqlTypeExplicitPrecedenceList;
import org.eigenbase.sql.type.SqlTypeName;

public class DrillFixedRelDataTypeImpl
extends RelDataTypeImpl {
    private List<RelDataTypeField> fields = Lists.newArrayList();
    private final RelDataTypeFactory typeFactory;

    public DrillFixedRelDataTypeImpl(RelDataTypeFactory typeFactory, List<String> columnNames) {
        this.typeFactory = typeFactory;
        for (String column : columnNames) {
            this.addField(column);
        }
        this.computeDigest();
    }

    private void addField(String columnName) {
        RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(columnName, this.fields.size(), this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.ANY), true));
        this.fields.add(newField);
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        return this.fields;
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public RelDataTypeField getField(String fieldName, boolean caseSensitive) {
        for (RelDataTypeField f : this.fields) {
            if (!fieldName.equalsIgnoreCase(f.getName())) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (RelDataTypeField f : this.fields) {
            fieldNames.add(f.getName());
        }
        return fieldNames;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.ANY;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new SqlTypeExplicitPrecedenceList(Collections.emptyList());
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(DrillFixedRecordRow" + this.getFieldNames() + ")");
    }

    @Override
    public boolean isStruct() {
        return true;
    }
}

